<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

use App\Storage;
use App\Section;
use App\Acf;
use App\ToType;

class SectionFactory {

    public $acf_key = 'section_list';

    public $acf_section_key = 'acf_fc_layout';

    public $post_id = 0;

    public function getSectionsData(){
       return ToType::evaluate(Acf::get($this->acf_key, $this->post_id), 'arr');
    }

    public function get(){
        $to_return = [];
        foreach($this->getSectionsData() as $section_data){
            $to_return[] = new Section(
                $section_data[$this->acf_section_key] ?? '',
                ToType::evaluate($section_data, 'arr'),
                'template-parts/sections/'
            );
        }
        return $to_return;
    }

    public function render(){
        foreach($this->getSectionsData() as $section_data){
            $section = new Section(
                $section_data['acf_fc_layout'] ?? '',
                ToType::evaluate($section_data, 'arr'),
                'template-parts/sections/'
            );
            $section->render();
        }
    }
}