<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

class Storage {

    /**
     * Array of stored properties
     * 
     * @var array
     */
    private static $props = [];

    /**
     * Method to set property
     * 
     * @param string $key
     * 
     * @param mixed $value
     */
    public static function set(string $key, $value){
        self::$props[$key] = $value;
    }

    /**
     * Method to get property with array of keys
     * For example Storage::get('confing', 'dev', 'version') will retrun
     * self::$props['config']['dev']['versian'] value
     * 
     * @param array ...$keys
     * 
     * @return mixed $to_return
     */
    public static function get(string ...$keys){
        $to_return = self::$props;
        for($i = 0;$i < count($keys); $i++){
            $key = $keys[$i];
            if(isset($to_return[$key])){
                $to_return = $to_return[$key];
            } else {
                return NULL;
            }
        }
        return $to_return;
    }

}