<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

class ToType {
    public static function evaluate($var, $type){
        if($type){
            switch ($type) {
                case 'string':
                case 'str':
                    if(!is_array($var)){
                        $var = strval($var);
                    } else {
                        $var = '';
                    }
                    break;
                case 'array':
                case 'arr':
                    if(is_object($var)){
                        $var = (array)$var;
                    } elseif(!is_array($var)){
                        $var = array();
                    }
                    break;
                case 'boolean':
                case 'bool':
                    $var = boolval($var);
                    break;
                case 'int':
                case 'integer':
                    $var = intval($var);
                    break;
                case 'float':
                    $var = floatval($var);
                    break;
            }
        }
        return $var;
    }
}