<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

class Validate {
    public static function check($var, string $type = 'str', $prop = NULL){
        if(is_array($var) && (strstr($type, 'arr/') || strstr($type, 'array/'))){
            $type = explode('/', $type)[1] ?? NULL;
            foreach($var as $key=>$value){
                if(self::check($value, $type) == false){
                    return false;
                }
            }
            return true;
        } else {
            switch($type){
                case 'min':
                    if(is_int($prop)){
                        $len = 0;
                        if(is_string($var)){
                            return strlen($var) >= $prop;
                        } elseif(is_array($var)){
                            return count($var) >= $prop;
                        }
                    }
                    break;
                case 'max':
                    if(is_int($prop)){
                        $len = 0;
                        if(is_string($var)){
                            return strlen($val) <= $prop;
                        } elseif(is_array($var)){
                            return count($val) <= $prop;
                        }
                    }
                    break;
                case 'string':
                case 'str':
                    return is_string($var);
                    break;
                case 'boolean':
                case 'bool':
                    $const = FILTER_VALIDATE_BOOLEAN;
                    break;
                case 'int':
                case 'integer':
                    $const = FILTER_VALIDATE_INT;
                    break;
                case 'float':
                    $const = FILTER_VALIDATE_FLOAT;
                    break;
                case 'url':
                    $const = FILTER_VALIDATE_URL;
                    break;
                case 'email':
                case 'mail':
                    $const = FILTER_VALIDATE_EMAIL;
                    break;
                case 'json':
                    return is_string($var) && json_decode($var, true) && (json_last_error() == JSON_ERROR_NONE) ? true : false;
                    break;
                default:
                    return false;
                    break;
            }
        }
        if(isset($const)){
            return !is_null(filter_var($var, $const, FILTER_NULL_ON_FAILURE));
        } else {
            return false;
        }
    }
}