<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

use Walker_Nav_Menu;

class Walker extends Walker_Nav_Menu {

	function start_el(&$output, $item, $depth=0, $args=array(), $id = 0) {
		$output .= '<li>' . $args->link_before;
		$output .= '<a href="' . $item->url . '" target="'.$item->target.'" ';

		// adding classes to a link
		$output .= 'class="';

		// active class
		if(is_array($item->classes) && in_array('current-menu-item', $item->classes) && array_key_exists('active_class', $args->extra)){
			$output .= $args->extra['active_class'] . ' ';
		}

		// adding parent class
		if($args->walker->has_children && array_key_exists('parent_class', $args->extra)){
			$output .= $args->extra['parent_class'];
		}

		// classes end
		$output .= '" ';

		// adding custom parent attributes
		if(array_key_exists('parent_attr', $args->extra) && is_array($args->extra['parent_attr']) && !empty($args->extra['parent_attr']) && $args->walker->has_children){
			$output .= implode(' ', array_map(function($attr, $value){
				return $attr . '="' . $value . '"';
			}, array_keys($args->extra['parent_attr']), array_values($args->extra['parent_attr'])));
		}

		// adding target and rel
		if(array_key_exists('target', $args->extra) && !empty(strval($args->extra['target']))){
			$output .= 'target="' . $args->extra['target'] . '" rel="noreferrer"';
		}


		if(array_key_exists('icon', $args->extra) && $args->extra['icon'] == true){
			$output .= ' aria-label="' . $item->url . '"><i class="';
		} else {
			$output .= '>';
		}
	
		// link text
		$output .= $item->title;
	
		// if icon instead of linktext
		if(array_key_exists('icon', $args->extra) && $args->extra['icon'] == true){
			$output .= '"></i>';
		}

		// dropdown extra
		if($args->walker->has_children && array_key_exists('dropdown_link_extra', $args->extra)){
			$output .= $args->extra['dropdown_link_extra'];
		}

		$output .=  '</a>' . $args->link_after;
	}
	
	function end_el(&$output, $item, $depth=0, $args=array(), $id = 0) {
		$output .= '</li>';
	}
	
	function start_lvl(&$output, $depth = 0, $args = array()){
		$output .= '<ul';

		if(array_key_exists('dropdown_list_class', $args->extra)){
			$output .= ' class="' . $args->extra['dropdown_list_class'] . '"';
		}

		$output .= '>';
	}
	
	function end_lvl(&$output, $depth=0, $args=array()) {
		$output .= '</ul>';
	}
	
}