<?php

if(!defined('ABSPATH')){
	exit;
}

use App\Storage;

/**
 * Setup Application core state
 * 
 * @since v.0.1.4
 */
Storage::set('config', [

    /**
     * Indicates whether theme is the development process
     * 
     * @var boolean
     */
    "dev" => true,


    /**
     * Indicates whether theme debug mode is enabled
     * 
     * @var boolean
     */
    "debug" => false,

    
    /**
     * ACF needles
     * - acf json path (used to sync)
     * - acf plugin url (used to correct theme acf assets url base)
     * 
     * @var array
     */
    "acf" => [

        "json" => get_template_directory().'/includes/acf-json/',

        "url" => get_stylesheet_directory_uri().'/includes/acf-plugin/',

    ], 


    /**
     * Theme version
     * 
     * @var float
     */
    "version" => wp_get_theme()->version,


    /**
     * Theme api endpoint controllers
     * This variable is sent to App\Rest::massRegister method
     * 
     * @var array
     */
    "api" => [

        'App\Rest\GetCart::init',

        'App\Rest\AddToCart::init',

        'App\Rest\GetProducts::init',

        'App\Rest\GetComments::init',

        'App\Rest\SearchProducts::init',

        'App\Rest\PostComment::init'

    ],


    /**
     * Theme assets config
     * 
     * - path
     * - url
     * - version (Example: wp_get_theme()->version | current_time('timestamp'))
     * - scripts (used by AssetsWizard class)
     * - styles (used by AssetsWizard class)
     * 
     * @var array
     */
    "assets" => [

        "path" => get_template_directory().'/assets/', 

        "url" => get_template_directory_uri().'/assets/', 

        "version" => wp_get_theme()->version,

        "scripts" => [

            // general scripts
            ['script', 'script.js', array('jquery')],

            ['header', 'header.js', array('jquery', 'script')],

            // product/cart pages
            ['product', 'product.js', array('jquery', 'script')],

            ['cart', 'cart.js', array('jquery', 'script')],

            // sections
            ['section-tabs', 'sections/tabs.js', array('jquery', 'script')],
            
            ['section-blog-page', 'sections/blog-page.js', array('jquery', 'script')],
            
            ['section-blog-single', 'sections/blog-single.js', array('jquery', 'script')],
            
            ['section-additional-page', 'sections/additional-page.js', array('jquery', 'script')],
            
            ['section-filter', 'sections/filter.js', array('jquery', 'script')],
            
            ['section-installation-steps', 'sections/installation-steps.js', array('jquery', 'script')],
            
            ['section-faq-single', 'sections/faq-single.js', array('jquery', 'script')],
            
            ['section-complete-guide', 'sections/complete-guide.js', array('jquery', 'script')]
            
        ],
        
        // theme styles
        "styles" => [

            // general
            ['style', 'style.css', array()],

            ['header', 'header.css', array('style')],

            ['footer', 'footer.css', array('style')],

            ['search', 'search.css', array('style')],

            ['404', '404.css', array('style')],

            // woocommerce pages
            ['product', 'product.css', array('style')],

            ['cart', 'cart.css', array('style')],

            ['checkout', 'checkout.css', array('style')],

            ['thankyou', 'thankyou.css', array('style')],

            // sections
            ['section-entry', 'sections/entry.css', array('style')],

            ['section-featured', 'sections/featured.css', array('style')],

            ['section-choose-by-provider', 'sections/choose-by-provider.css', array('style')],

            ['section-why-choose-us', 'sections/why-choose-us.css', array('style')],

            ['section-services', 'sections/services.css', array('style')],

            ['section-tabs', 'sections/tabs.css', array('style')],

            ['section-call-us', 'sections/call-us.css', array('style')],

            ['section-how-it-works', 'sections/how-it-works.css', array('style')],

            ['section-blue-info', 'sections/blue-info.css', array('style')],

            ['section-certify', 'sections/certify.css', array('style')],

            ['section-additional-page', 'sections/additional-page.css', array('style')],

            ['section-resellers-page', 'sections/resellers-page.css', array('style')],

            ['section-blog-page', 'sections/blog-page.css', array('style')],

            ['section-blog-single', 'sections/blog-single.css', array('style')],

            ['section-case-study-page', 'sections/case-study-page.css', array('style')],

            ['section-case-study-single', 'sections/case-study-single.css', array('style')],

            ['section-category-single', 'sections/category-single.css', array('style')],

            ['section-complete-guide', 'sections/complete-guide.css', array('style')],

            ['section-faq-page', 'sections/faq-page.css', array('style')],

            ['section-faq-posts', 'sections/faq-posts.css', array('style')],

            ['section-floor-plan', 'sections/floor-plan.css', array('style')],

            ['section-pricing-overview', 'sections/pricing-overview.css', array('style')],

            ['section-installation-steps', 'sections/installation-steps.css', array('style')],

            ['section-shipping-and-delivery', 'sections/shipping-and-delivery.css', array('style')],

            ['section-filter', 'sections/filter.css', array('style')],

            ['section-rate-us', 'sections/rate-us.css', array('style')]

        ]

    ]

]);