<?php
if(!defined('ABSPATH')){
	exit;
}

/**
 * Legacy functions that will be deprecated within next few releases
 * This code will migrate and to be deprecated
 */

/**
 * Function to get site logo image url
 * 
 * @param string $size
 * 
 * @return string $url
 */
if(!function_exists('wp_get_site_logo')):
  function wp_get_site_logo(string $size = 'full'){
      return msb_get_image_url(get_theme_mod('custom_logo'), $size);
  }
endif;

/**
 * Function to format field group
 * used in woocommerce_checkout_fields hook
 * 
 * @param array $fields, 
 * 
 * @param array $options
 * 
 * @return array
 * 
 */
if(!function_exists('wp_get_checkout_fields_formatted')):
  function wp_get_checkout_fields_formatted(array $fields, array $options){
    if(!empty($options)){
      // mark to identify required option fields
      $required_mark = '_required_option';
    
      foreach($fields as $key=>$option){
        // unset classes
        unset($fields[$key]['label_class']);
    
        // format label
        if(isset($options[$key]) && $options[$key]){
          $fields[$key]['label'] = $options[$key];
          unset($options[$key]);
        }
        // set required options
        if(isset($options[$key . $required_mark])){
          $fields[$key]['required'] = boolval($options[$key . $required_mark]);
          unset($options[$key . $required_mark]);
        }
      }
    }
    return array(
      'fields' => $fields,
      'options' => $options
    );
  }
endif;

/**
 * Get field html without placeholder. 
 * Generate field html with 'woocommerce_form_field' function
 * 
 * @param string $field_name
 * 
 * @param array $fields
 * 
 * @param WC_Checkout $checkout
 * 
 * @return string $html
 * 
 */
if(!function_exists('wp_get_checkout_field_html')):
  function wp_get_checkout_field_html(string $field_name, array $fields, WC_Checkout $checkout){
    $fields['return'] = true;
    unset($fields[$field_name]['placeholder']);
    $html = woocommerce_form_field($field_name, $fields[$field_name], $checkout->get_value($field_name));
    return $html;
  }
endif;

/**
 * Function to get product category fullname.
 * Checks if category_full_name meta exists and
 * return or its value or cateogry object name
 * 
 * @param mixed $category
 * 
 * @return string $fullname|$category->name
 */
if(!function_exists('wp_get_category_fullname')):
  function wp_get_category_fullname($category = NULL){
      if(is_null($category) && term_exists(App\Storage::get('queried_object_id'), 'product_cat')){
          $category = get_term(App\Storage::get('queried_object_id'), 'product_cat');

      } elseif(!is_object($category) && term_exists($category, 'product_cat')){
          $category = get_term($category, 'product_cat');

      } elseif(!property_exists($category, 'term_id') || !term_exists($category->term_id)){
          return '';

      }
      $fullname = App\Acf::get('category_full_name', $category, 'str');
      if($fullname){
          return $fullname;

      } else {
          return $category->name;
      }
  }
endif;

/**
 * Get product page template part based in
 * 'template-parts/product/' directory
 * 
 * @param string $name
 */
if(!function_exists('wp_get_product_template_part')):
  function wp_get_product_template_part(string $name){
    get_template_part('template-parts/product/' . $name);
  }
endif;

/**
 * Get product coverage, by default brings 
 * single product as source of coverages
 * 
 * Rerturns coverage last category name
 * 
 * @param mixed|NULL $product
 * 
 * @return string $coverage
 */
if(!function_exists('wp_get_product_coverage')):
  function wp_get_product_coverage($product = ''){
    if(!$product) $product_id = App\Storage::get('queried_object_id');

    if($product instanceof WC_Product){
      $wc_product = $product;
    } else {
      $wc_product = wc_get_product($product);
    }

    if(!$wc_product) return '';
    global $WC_booster;
    $coverage = $WC_booster->wc_get_product_categories($wc_product, 'coverage');
    if(!$coverage) return '';
    return end($coverage)->name;
  }
endif;

/**
 * Add Product Category Color Custom Field the old way
 */

add_action('product_cat_add_form_fields', 'add_product_cat_color_field');
add_action('product_cat_edit_form_fields', 'edit_product_cat_color_field');
add_action('edited_product_cat', 'save_product_cat_color_field');
add_action('create_product_cat', 'save_product_cat_color_field');

if(!function_exists('add_product_cat_color_field')):
  function add_product_cat_color_field() { 
  ?>
  <div class="form-field">
    <label for="product_cat_color"><?=__('Category Color', 'booster')?></label>
      <input type="text" name="product_cat_color" id="product_cat_color" value="" />
    <p class="description"><?=__('Use CSS colors in this input', 'booster')?></p>
  </div>
  <?php
  }
endif;

if(!function_exists('save_product_cat_color_field')):
  function save_product_cat_color_field($term_id){
      if(isset($_POST['product_cat_color'])){
      update_option('cat_background_color'.$term_id, $_POST['product_cat_color']);
    }
  }
endif;

if(!function_exists('edit_product_cat_color_field')):
  function edit_product_cat_color_field($category) {
      $background_color = get_option('cat_background_color'.$category->term_id);
  ?>
  <tr class="form-field">
    <th scope="row" valign="top">
      <label for="product_cat_color"><?=__('Category Color', 'booster')?></label>
    </th>
    <td>
      <input type="text" name="product_cat_color" id="product_cat_color" value="<?=$background_color?>">
      <p class="description">Use CSS colors in this input</p>	
    </td>
  </tr>
  <?php
  }
endif;