<?php
/**
* Template Name: Search
*/
if (!defined('ABSPATH')){
	exit;
}
if(!trim(get_search_query())) wp_redirect(home_url());
$page_template_id = App\Storage::get('queried_object_id');
get_header();
// get products
$wp_query = new WP_Query(array(
    'posts_per_page' => 99,
    'post_type' => 'product',
    's' => sanitize_text_field($_GET['s']),
    'tax_query' => array(
        array(
            'taxonomy'      => 'product_cat',
            'terms'         => App\Acf::get('exclude_categories', $page_template_id, 'arr'),
            'field'         => 'term_id',
            'operator'      => 'NOT IN',
            'include_children' => false
        ),
        array(
            'taxonomy' => 'product_visibility',
            'field'    => 'name',
            'terms'    => array('exclude-from-search'),
            'operator' => 'NOT IN',
            'include_children' => false,
        )
    ),
    'orderby' => 'menu_order',
    'order' => 'ASC'
));

// fitler products
$products = $wp_query->posts;

if(empty($products)): ?>
<h1 class="page_title grid"><?=App\Acf::get('no_result_text_prefix', $page_template_id, 'str') . ' ' . sanitize_text_field($_GET['s'])?></h1>
<?php else: ?>
    <div class="grid search_page">
        <h1 class="page_title"><?=App\Acf::get('result_text_prefix', $page_template_id, 'str') . ' ' . sanitize_text_field($_GET['s'])?></h1>
        <ul class="shop_page_products">
            <?php 
            // highlight bestsellers option
            $highlight_bestsellers = App\Acf::get('highlight_bestsellers', $page_template_id, 'bool');
            // get stars icon url
            $stars_image = msb_get_image_url(App\Acf::get('stars_image', 'option', 'str'), 'thumbnail');
            // get text variables
            $section_sale_text = App\Acf::get('sale_text', $page_template_id, 'str');
            $section_bestseller_text = App\Acf::get('bestseller_text', $page_template_id, 'str');
            $section_bestseller_yellow_text = App\Acf::get('bestseller_yellow_text', $page_template_id, 'str');
            $section_review_text = App\Acf::get('review_text', $page_template_id, 'str');
            $section_product_link_text = App\Acf::get('product_link_text', $page_template_id, 'str');
            $section_sale_save_text = App\Acf::get('you_save_text', $page_template_id, 'str');
            // products loop
            foreach($products as $product):
                // get wc product
                $wc_product = wc_get_product($product->ID);
                // get msb product
                $msb_product = new App\Product($wc_product);
                // add class
                $bestseller_class = $highlight_bestsellers && $msb_product->is_bestseller() ? ' class="bestseller"' : '';
                // show only first bestseller
                if($msb_product->is_bestseller()){
                    $highlight_bestsellers = false;
                }
                ?>
                <li <?=$bestseller_class?>>
                    <div class="image"><?php 
                        if($wc_product->is_on_sale() && $section_sale_text):
                            ?><div class="sale"><?=$section_sale_text?></div><?php
                        endif; ?>
                        <a href="<?=$msb_product->get_permalink()?>"><img data-src="<?=$msb_product->get_featured_image_url('medium')?>" class="lazyload" alt="<?=$wc_product->get_title()?>"></a>
                        <?php if($msb_product->is_bestseller() && $highlight_bestsellers && $section_bestseller_text): ?>
                            <div class="free"><?=$section_bestseller_text?></div>
                        <?php endif; ?>
                    </div>
                    <div class="main">
                        <?php if($wc_product->get_reviews_allowed()): ?>
                            <div class="rating lazyload" data-bg-src="<?=$stars_image?>"><span style="width: <?=$msb_product->get_average_rating() * 20?>%;" class="lazyload" data-bg-src="<?=$stars_image?>"></span></div>
                            <div class="reviews"><?=$msb_product->get_reviews_count()?> <?=$section_review_text?></div>
                        <?php endif;
                        if($msb_product->is_bestseller() && $highlight_bestsellers && $section_bestseller_yellow_text): ?>
                            <div class="choice"><?=$section_bestseller_yellow_text?></div>
                        <?php endif; ?>
                        <div class="title"><a href="<?=$msb_product->get_permalink()?>"><?=$wc_product->get_title()?></a></div>
                    </div>
                    <div class="coverage"><?=$msb_product->get_coverage()?></div>
                    <ul class="by-use">
                    <?php
                    if($msb_product->get_ideal_for()){
                        foreach($msb_product->get_ideal_for() as $category){
                            $thumb_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                            $thumb = msb_get_image_url($thumb_id, 'thumbnail');
                            ?>
                            <li><i class="lazyload" data-bg-src="<?=$thumb?>" title="<?=$category->name?>"></i></li>
                        <?php
                        }
                    }
                    ?>
                    </ul>
                    <ul class="providers">
                    <?php
                    if($msb_product->get_providers()):
                        foreach($msb_product->get_providers() as $category):
                            $thumb_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                            $thumb = msb_get_image_url($thumb_id, 'small_thumbnail');
                        ?>
                        <li><img class="lazyload" data-src="<?=$thumb?>" alt="<?=$category->name?>"></li>
                        <?php
                        endforeach;
                    endif;
                    ?>
                    </ul>
                    <div class="application">
                        <div class="band"><?php 
                        if($msb_product->has_band()){
                            ?><span style="background-color: <?=$msb_product->get_band_color()?>;"><?=$msb_product->get_band_name()?></span><?php
                        }
                        ?></div>
                        <div class="gsm"><span><?=$msb_product->get_gsm()?></span></div>
                    </div>

                    <div class="price_nd_link">
                        <div class="price">
                        <?php 
                        if($wc_product->is_on_sale()){
                            ?>
                            <del><?=$msb_product->get_regular_price(true)?></del>
                            <span><?=$msb_product->get_sale_price(true)?></span>
                            <strong><?=$section_sale_save_text . ' ' . wc_price($msb_product->get_regular_price() - $msb_product->get_sale_price()) ?></strong>
                            <?php 
                        } else {
                            ?>
                            <span><?=$msb_product->get_regular_price(true)?></span>
                            <?php
                        }
                        ?>
                        </div>
                        <div class="link">
                            <a href="<?=$msb_product->get_permalink()?>"><?=$section_product_link_text?></a>
                        </div>
                    </div>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif;
msb_get_sections();
get_footer();
?>