<?php 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$post_id = App\Storage::get('queried_object_id');
global $WC_booster;
global $wc_product;
global $msb_product;

?>
<ul class="product_page_main_specs">
    <?php 
    if($wc_product->get_reviews_allowed() && App\Acf::get('msb_product_rating_option', 'option', 'bool')):
        $stars_image = msb_get_image_url(get_field('stars_image', 'option'), 'thumbnail');
        ?>
        <li>
            <h5><?=App\Acf::get('msb_product_rating_label', 'option', 'str')?>:</h5>
            <div>
                <div class="product_page_main_reviews" style="background-image: url('<?=$stars_image?>');"><span style="background-image: url('<?=$stars_image?>'); width: <?=$msb_product->get_average_rating() * 20?>%;"></span></div>
                <a href="#" id="scroll_to_reviews" class="product_page_main_reviews_scroll"><?=$msb_product->get_reviews_count()?></a>
            </div>

        </li>
        <?php 
    endif;

    if($msb_product->has_band()):
        ?>
        <li>
            <h5><?=$WC_booster->wc_get_categories_label('band')?>:</h5>
            <div>
                <span class="product_page_main_band" style="background-color: <?=$msb_product->get_band_color()?>;"><?=$msb_product->get_band_name()?></span>
            </div>
        </li>
        <?php 
    endif;

    if($msb_product->get_coverage()):
        ?>
        <li>
            <h5><?=$WC_booster->wc_get_categories_label('coverage')?>:</h5>
            <div><?=$msb_product->get_coverage()?></div>
        </li>
        <?php 
    endif;

    if($msb_product->get_ideal_for()):
        ?>
        <li>
            <h5><?=$WC_booster->wc_get_categories_label('attr')?>:</h5>
            <div>
                <?php 
                foreach($msb_product->get_ideal_for() as $category):
                    $thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                    $thumbnail = msb_get_image_url($thumbnail_id, 'small_thumbnail');
                ?>
                <i class="product_page_main_by_use lazyload" data-bg-src="<?=$thumbnail?>" title="<?=$category->name?>"></i>
            <?php endforeach; ?>
            </div>

        </li>
        <?php 
    endif;

    if($msb_product->get_providers()):
        ?>
        <li>
            <h5><?=$WC_booster->wc_get_categories_label('providers')?>:</h5>
            <div>
                <?php 
                foreach($msb_product->get_providers() as $category): 
                    $thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                    $thumbnail = msb_get_image_url($thumbnail_id, 'small_thumbnail');
                ?>
                <i class="product_page_main_provider lazyload" data-bg-src="<?=$thumbnail?>" title="<?=$category->name?>"></i>
            <?php endforeach; ?>
            </div>
        </li>
    <?php 
    endif;
    if($msb_product->get_frequency()):
        ?>
        <li>
            <h5><?=$WC_booster->wc_get_categories_label('frequency')?>:</h5>
            <div><?=$msb_product->get_frequency()?></div>

        </li>
        <?php 
    endif;

    if($msb_product->get_gsm()):
        ?>
        <li>
            <h5><?=$WC_booster->wc_get_categories_label('gsm')?>:</h5>
            <div><?=$msb_product->get_gsm()?></div>
        </li>
        <?php 
    endif; 
    ?>
</ul>