<?php 
if(!defined('ABSPATH')){
	exit;
}
global $wc_product;
global $msb_product;
$stars_image = msb_get_image_url(App\Acf::get('stars_image', 'option', 'int'), 'thumbnail');
?>
<section class="product_page_reviews grid">
    <?php if(App\Acf::get('product_comments_section_title', 'option', 'bool')): ?>
        <h3 class="page_title"><?=App\Acf::get('product_comments_section_title', 'option', 'str')?></h3>
    <?php endif; ?>
    <header class="product_page_reviews_header">
        <div class="product_page_reviews_header_rating">
            <h4><?=number_format($msb_product->get_average_rating(), 1)?></h4>
            <div data-bg-src="<?=$stars_image?>" class="lazyload"><span data-bg-src="<?=$stars_image?>" class="lazyload" style="width: <?=$msb_product->get_average_rating() * 20?>%;"></span></div>
            <?php if(App\Acf::get('product_customer_reviews_text', 'option', 'bool')): ?>
                <p><?=$msb_product->get_reviews_count() . ' ' . App\Acf::get('product_customer_reviews_text', 'option', 'str')?></p>
            <?php endif; ?>
        </div>
        <?php
        $reviews_form_data = App\Acf::get('product_reviews_form', 'option', 'arr');
        $questions_form_data = App\Acf::get('product_questions_form', 'option', 'arr');
        ?>
        <div class="product_page_reviews_header_toggle_buttons">
            <a href="#" data-toggle-id="write"><i class="far fa-edit"></i><?=$reviews_form_data['write_review_text'] ?? ''?></a>
            <a href="#" data-toggle-id="ask"><i class="far fa-comments"></i><?=$questions_form_data['ask_question_text'] ?? ''?></a>
        </div>
    </header>
    <div class="product_page_reviews_header_forms">
        <div id="write">
            <?php wp_get_product_template_part('reviews/form'); ?>
        </div>
        <div id="ask">
            <?php wp_get_product_template_part('questions/form'); ?>
        </div>
    </div>
    <div class="product_page_reviews_content">
        <header>
            <a href="#" data-toggle-id="comment_reviews" class="active"><?=App\Acf::get('product_reviews_section_title', 'option', 'str')?> (<?=$msb_product->get_reviews_count()?>)</a>
            <?php

            $loop = new WP_Query(array(
                    'post_type' => 'que_ans',
                    'posts_per_page' => 100,
                )
            );
            $qa_product_id = get_the_ID();
            ?>
            <?php
            $qu_count = 0 ;
            while ($loop->have_posts()) : $loop->the_post();  ?>
                <?php
                $answer = get_field( "answer", get_the_ID() );
                $value = get_field( "product_id", get_the_ID() );
                if ($qa_product_id == $value && $answer){
                    $qu_count ++ ;
                }
                ?>

            <?php endwhile;


            wp_reset_query(); ?>

            <a href="#" data-toggle-id="comment_questions"><?=App\Acf::get('product_questions_section_title', 'option', 'str')?> (<?=$qu_count?>)</a>
        </header>
        <div class="product_page_comment_area active" id="comment_reviews">
            <?php if($msb_product->get_reviews_count()) wp_get_product_template_part('reviews/list'); ?>
        </div>
        <div class="product_page_comment_area" id="comment_questions">
            <?php  wp_get_product_template_part('questions/list'); ?>
        </div>
    </div>
</section>