<?php 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$post_id = App\Storage::get('queried_object_id');

global $wc_product;

$product_featured_image = msb_get_image_url(get_post_thumbnail_id($wc_product->get_id()), 'full');
$product_gallery_option = boolval(get_field('gallery_option', $post_id));
$product_gallery = $wc_product->get_gallery_image_ids();
$main_specs_option = get_field('main_tech_gallery_option', $post_id);
$bestseller_option = boolval(get_field('bestseller_option', $wc_product->get_id()));

if($bestseller_option){
    $bestseller_crimping_tool = get_field('bestseller_crimping_tool', $wc_product->get_id());
    $bestseller_label = get_field('msb_product_bestseller_label', 'option');
}

?>
<div class="product_page_main_media">
    <div class="product_page_main_media_image">
        <?php if(isset($bestseller_label) && $bestseller_label): ?>
        <span class="product_page_main_media_bestseller_label"><?=$bestseller_label?></span>
        <?php endif ?>
        <div class="image_loader">
         <img data-src="<?=$product_featured_image?>" class="lazyload" alt="<?=$wc_product->get_name()?>">
        </div>
    </div>
    <?php if($product_gallery_option): ?>
    <div class="product_page_main_media_images_wrapper">
        <ul class="product_page_main_media_images">
            <li><a href="#" data-image="<?=$product_featured_image?>"><img data-src="<?=$product_featured_image?>" class="lazyload" alt="<?=$wc_product->get_name()?>"></a></li>
        <?php 
        if(!empty($product_gallery)): 
            foreach($product_gallery as $image_id):
                $thumbnail_url = wp_get_attachment_image_url($image_id, 'thumbnail');
                $image_url = wp_get_attachment_image_url($image_id, 'full');
            ?>
            <li><a href="#" data-image="<?=$image_url?>"><img data-src="<?=$thumbnail_url?>" class="lazyload" alt="<?=$wc_product->get_name()?>"></a></li>
            <?php 
            endforeach;
        endif; 
        ?>
        </ul>
    </div>
    <?php endif;

    if($bestseller_option && $bestseller_crimping_tool): ?>
    <img data-src="<?=$bestseller_crimping_tool['url']?>" class="lazyload product_page_crimping_tool" alt="<?=$bestseller_crimping_tool['alt']?>">
    <?php endif ?>
</div>