<?php 
if(!defined('ABSPATH')){
	exit;
}

global $post_id;
global $wc_product;
global $msb_product;

// price data
$price = $wc_product->is_on_sale() ? intval($msb_product->get_sale_price()) : intval($msb_product->get_regular_price());
?>
<div class="product_page_main_payment_wrapper">
    <div class="product_page_loading" id="variation_app_loading">
        <i class="far fa-circle-notch fa-spin"></i>
    </div>
    <div class="product_page_main_payment_header">
        <h3 class="product_page_main_payment_price" id="product_regular_price"><?=get_woocommerce_currency_symbol()?> <span><?=$price?></span></h3>
        <p class="product_page_main_payment_sale"<?php if(!$wc_product->is_on_sale()){ ?> style="display: none;"<?php } if($wc_product->is_type('variable')): ?> id="product_sale_prices"<?php endif ?>><?=apply_filters('the_content', App\Acf::get('product_sale_text', 'option', 'str'))?></span></p>
        <?php if(App\Acf::get('product_untis_sold_text', 'option', 'bool')): ?>
            <p class="product_page_main_payment_sold"><?=apply_filters('the_content', App\Acf::get('product_untis_sold_text', 'option', 'str'))?>: <?=$msb_product->get_units_sold()?></span></p>
        <?php endif;
        if(App\Acf::get('product_shipping_under_price_text', 'option', 'bool')): ?>
            <p class="product_page_main_payment_shipping"><?=App\Acf::get('product_shipping_under_price_text', 'option', 'str')?></p>
        <?php endif; ?>
    </div>
    <?php if(App\Acf::get('kit_list', $post_id, 'bool')): ?>
    <div class="product_page_main_payment_overview">
        <?php if(App\Acf::get('product_including_kit_title', 'option', 'bool')): ?><h4><?=App\Acf::get('product_including_kit_title', 'option', 'str')?></h4><?php endif; ?>
        <?php if(App\Acf::get('product_including_kit_list_title', 'option', 'bool')): ?><h5><?=App\Acf::get('product_including_kit_list_title', 'option', 'str')?>:</h5><?php endif; ?>
        <ul>
        <?php foreach(App\Acf::get('kit_list', $post_id, 'arr') as $kit): ?>
            <li><?=apply_filters('the_content', $kit['kit'])?></li>
        <?php endforeach; ?>
        </ul>
    </div>
    <?php endif; wp_get_product_template_part('add-to-cart'); ?>
</div>
<?php 
// request installation link
$wc_request_link_url = App\Acf::get('product_request_installation_link_to', 'option', 'str');
if($wc_request_link_url): ?>
    <a href="<?=$wc_request_link_url?>" class="product_page_main_request" target="_blank">
        <i class="lazyload" data-bg-src="<?=App\Acf::get('product_request_installation_link_icon', 'option', 'str')?>"></i>
        <span><?=App\Acf::get('product_request_installation_link_text', 'option', 'str')?></span>
    </a>
<?php endif;
// price match guarantee link data
$price_match_link_url = App\Acf::get('product_price_match_guarantee_link_to', 'option', 'str');
if($price_match_link_url): ?>
    <a href="<?=$price_match_link_url?>" class="product_page_main_guarantee" target="_blank">
        <i class="lazyload" data-bg-src="<?=App\Acf::get('product_price_match_guarantee_link_icon', 'option', 'str')?>"></i>
        <span><?=App\Acf::get('product_price_match_guarantee_link_text', 'option', 'str')?></span>
    </a>
<?php endif ?>