<?php
if (!defined('ABSPATH')) {
    exit;
}
$questions_list_data = get_field('product_questions_list', 'option');

if ($questions_list_data) {
    $questions_verified_text = $questions_list_data['verified_customer_text'];
    $questions_show_more_text = $questions_list_data['show_more_text'];
    $questions_share_text = $questions_list_data['share_text'];
} else {
    $questions_verified_text = '';
    $questions_show_more_text = '';
    $questions_share_text = '';
}
$site_logo_thumb = wp_get_site_logo('small');
$stars_image = msb_get_image_url(get_field('stars_image', 'option'), 'thumbnail');
$product_permalink = get_permalink(App\Storage::get('queried_object_id'));
?>
<div class="comment_list_app">
    <div class="comment_list_app_content">
        <?php

        $loop = new WP_Query(array(
                'post_type' => 'que_ans',
                'posts_per_page' => 100,
            )
        );
        $product_id = get_the_ID();
        $url = get_permalink($product_id);
        ?>
        <?php

        while ($loop->have_posts()) : $loop->the_post(); ?>
        <?php
        $post_ids = get_the_ID();

            $value = get_field( "product_id", $post_ids );
            $answer = get_field( "answer", $post_ids );
            if ($product_id == $value && $answer){ ?>
                <article>
                    <?php
                    $string = get_the_title();
                    $firstChar = mb_substr($string, 0, 1, "UTF-8");
                    ?>
                    <div class="side"><?php echo strtoupper($firstChar) ?></div>
                    <div class="main">
                        <header><b><?php the_title() ?></b> Verified Customer<span><?php echo get_the_date('Y/m/d'); ?></span></header>
                        <p><?php the_content(); ?></p>
                        <style>
                            .children{
                                list-style: none outside;
                                margin: 20px 0 0 50px;
                                margin-left: 0px!important;
                                border-left: 2px solid #accee9;
                                margin-top: 25px!important;
                                padding-left: 8px!important;
                            }
                            li#li-comment-48589{
                                border-top: 1px solid #e3e3e3!important;
                                font-family: Open Sans!important;
                                padding: 25px 0 22px!important;
                                margin: 0 10px!important;
                            }
                            .review-avatar-wrapper.pull-left{
                                position: relative;
                                width: 45px;
                                height: 45px;
                                margin-right: 8px;
                                float: left;
                            }
                        </style>
                        <ul class="children">
                            <li class="comment odd alt thread-odd thread-alt depth-1 disable" id="li-comment-48589" data-star="0">

                                <div  class="comment_container">

                                    <div class="review-avatar-wrapper pull-left">
                                        <img class="img-responsive" src="<?= msb_get_image_url(get_theme_mod('custom_logo'), 'medium') ?>">
                                    </div>
                                    <div class="comment-text" style="border:none">
                                        <p class="meta" style=" margin: 0;">
                                            <strong itemprop="author" style="color: #2f84ed;"><?= get_bloginfo('name') ?></strong>
                                        </p>

                                        <div itemprop="description" class="description">
                                            <p style="color: #4f4f4f;padding-bottom: 5px;font-weight: bold;font-size: 14px;margin: 0;">
                                            </p>
                                            <p style="color: #4f4f4f;line-height: 17px;    font-size: 14px;">
                                            <?=$answer?>
                                            			</p>
                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="clearfix"></div>
                                    </div>
                                </div>

                            </li><!-- #comment-## -->
                        </ul>
                        <ul class="attachments"></ul>
                        <footer><a href="#" data-toggle-sibling="ul">Share</a>

                            <ul>
                                <li><a rel="noreferrer"
                                       href="https://www.facebook.com/sharer/sharer.php?u=<?= $url ?>"
                                       target="_blank">Facebook</a></li>
                                <li><a rel="noreferrer"
                                       href="http://twitter.com/share?text=saaaaaaaaaaaaaa&amp;url=<?= $url ?>>"
                                       target="_blank">Twitter</a></li>
                                <li><a rel="noreferrer"
                                       href="https://www.linkedin.com/shareArticle?mini=true&amp;source=Yotpo&amp;summary=saaaaaaaaaaaaaa&amp;url=<?= $url ?>"
                                       target="_blank">LinkedIn</a></li>
                            </ul>
                        </footer>
                    </div>
                </article>
           <?php }
            ?>

        <?php endwhile;

        wp_reset_postdata();
        wp_reset_query(); ?>


    </div>
    <div class="comment_list_app_content_show_more">
        <a href="#" id="questions_list_show_more"><?= $questions_show_more_text ?></a>
    </div>
    <!--    <div class="product_page_loading" id="questions_list_loading">-->
    <!--        <i class="far fa-circle-notch fa-spin"></i>-->
    <!--    </div>-->
</div>
<script>
    window.question_list_app_props = {
        answer_thumb_url: <?=json_encode($site_logo_thumb)?>,
        product_link: <?=json_encode($product_permalink)?>,
        share_text: <?=json_encode($questions_share_text)?>,
        verified_text: <?=json_encode($questions_verified_text)?>,
        stars_image: <?=json_encode($stars_image)?>
    }
</script>