<?php 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $post_id;

$related_products = wc_get_related_products($post_id, 4);
// filter if the product does not exists
$related_products = array_filter($related_products, function($product_id){
	return get_post_type($product_id) == 'product';
});
if($related_products):
	global $WC_booster;
	// text variables
	$section_title = App\Acf::get('product_related_products_section_title', 'option', 'str');
	$bestseller_text = App\Acf::get('product_related_products_bestseller_text', 'option', 'str');
	$view_more_link_text = App\Acf::get('product_related_products_link_text', 'option', 'str');
	?>
	<section class="product_page_related_products grid">
		<h3 class="page_title"><?=$section_title?></h3>
			<ul class="featured_section_product_list">
			<?php
				foreach($related_products as $product_id):
					$wc_product = wc_get_product($product_id);
					if(!$wc_product) continue;
					$msb_product = new App\Product($wc_product);
					?>
					<li>
						<?php if($msb_product->is_bestseller()): ?>
							<span class="featured_section_product_bestseller"><?=$bestseller_text?></span>
						<?php endif; ?>
						<a href="<?=$wc_product->get_permalink()?>" class="featured_section_product_thumb">
							<img data-src="<?=msb_get_image_url($wc_product->get_image_id(), 'medium')?>" alt="<?=$wc_product->get_name()?>" class="lazyload">
						</a>
						<header class="featured_section_product_header">
							<a href="<?=$wc_product->get_permalink()?>" class="featured_section_product_title"><?=$wc_product->get_name()?></a>
							<span class="featured_section_product_price">
							<?php 
							if($wc_product->is_on_sale()){
								?>
								<del><?=$msb_product->get_regular_price(true)?></del>
								<span><?=$msb_product->get_sale_price(true)?></span>
								<?php
							} else {
								?>
								<span><?=$msb_product->get_regular_price(true)?></span>
								<?php
							}
							?>
							</span>
						</header>
						<ul class="featured_section_product_description">
							<?php if($msb_product->get_coverage()): ?>
							<li>
								<h5 class="featured_section_product_description_title"><?=$WC_booster->wc_get_categories_label('coverage')?>:</h5>
								<p class="featured_section_product_description_content"><?=$msb_product->get_coverage()?></p>
							</li>
							<?php 
							endif;
							
							if($msb_product->get_ideal_for()): ?>
							<li>
								<h5 class="featured_section_product_description_title"><?=$WC_booster->wc_get_categories_label('attr')?>:</h5>
								<ul class="featured_section_product_description_content_list_by_use">
									<?php 
									foreach($msb_product->get_ideal_for() as $category): 
										$name = $category->name;
										$thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
										$thumbnail = msb_get_image_url($thumbnail_id, 'small_thumbnail');
									?>
									<li>
										<i class="featured_section_product_description_by_use_icon lazyload" title="<?=$name?>" data-bg-src="<?=$thumbnail?>"></i>
									</li>
									<?php endforeach; ?>
								</ul>
							</li>
							<?php 
							endif;
							
							if($msb_product->get_providers()):
							?>
							<li>
								<h5 class="featured_section_product_description_title"><?=$WC_booster->wc_get_categories_label('providers')?>:</h5>
								<ul class="featured_section_product_description_content_list_providers">
								<?php 
								foreach($msb_product->get_providers() as $category): 
									$name = $category->name;
									$thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
									$thumbnail = msb_get_image_url($thumbnail_id, 'small_thumbnail');
									?>
									<li>
										<i class="featured_section_product_description_provider_icon lazyload" title="<?=$name?>" data-bg-src="<?=$thumbnail?>"></i>
									</li>
								<?php 
								endforeach; 
								?>
								</ul>
							</li>
							<?php endif ?>
						</ul>
						<div class="featured_section_product_links">
							<a href="<?=$wc_product->get_permalink()?>" 
							class="featured_section_product_info_link"><?=$view_more_link_text?></a>
						</div>
					</li>
				<?php 
				endforeach; 
				?>
			</ul>
	</section>
	<?php
endif;