<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$reviews_form_data = get_field('product_reviews_form', 'option');
if(!$reviews_form_data) return;

// text variables
$stars_image = msb_get_image_url(get_field('stars_image', 'option'), 'thumbnail');
$write_review_text = strval($reviews_form_data['write_review_text']);
$rating_label = strval($reviews_form_data['rating_label']);
$name_label = strval($reviews_form_data['name_label']);
$email_label = strval($reviews_form_data['email_label']);
$review_label = strval($reviews_form_data['review_label']);
$file_label = strval($reviews_form_data['file_label']);
$submit_text = strval($reviews_form_data['submit_text']);
$reviews_success_title = strval($reviews_form_data['submit_success_title']);
$reviews_success_message = strval($reviews_form_data['submit_success_message']);

// comment form data
$commenter  = wp_get_current_commenter();
$comment_form = array(
    'id_form'             => 'write_review_form',
    'title_reply'         => $write_review_text,
    'title_reply_before'  => '<h3>',
    'title_reply_after'   => '</h3>',
    'comment_notes_before' => '',
    'comment_notes_after' => '',
    'title_reply_to'      => '',
    'label_submit'        => $submit_text,
    'logged_in_as'        => '',
    'comment_field'       => ''
);
$name_email_required = boolval(get_option('require_name_email', 1));

$fields = array(
    'author' => array(
        'label'    => __( $name_label, 'booster' ),
        'type'     => 'text',
        'value'    => '',
        'required' => true,
    ),
    'email' => array(
        'label'    => __( $email_label, 'booster' ),
        'type'     => 'email',
        'value'    => $commenter['comment_author_email'],
        'required' => $name_email_required,
    )
);

$comment_form['fields'] = array();

foreach ( $fields as $key => $field ) {
    $field_html  = '<p class="comment-form-' . esc_attr( $key ) . '">';
    $field_html .= '<label for="' . esc_attr( $key ) . '">' . esc_html( $field['label'] );
    if ( $field['required'] ) {
        $field_html .= '&nbsp;<b>*</b>';
    }
    $field_html .= '</label><input id="' . esc_attr( $key ) . '" name="' . esc_attr( $key ) . '" type="' . esc_attr( $field['type'] ) . '" value="' . esc_attr( $field['value'] ) . '" /></p>';
    $comment_form['fields'][ $key ] = $field_html;
}
$account_page_url = wc_get_page_permalink( 'myaccount' );
if ( $account_page_url ) {
    $comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf( esc_html__( 'You must be %1$slogged in%2$s to post a review.', 'booster' ), '<a href="' . esc_url( $account_page_url ) . '">', '</a>' ) . '</p>';
}

if (wc_review_ratings_enabled()){
    $comment_form['comment_field'] = '
    <div class="comment-form-rating">
        <label for="rating">' . esc_html__( $rating_label, 'booster' ) . ' <b>*</b></label>
        <div class="write_rating lazyload" data-bg-src="' . $stars_image . '">
            <a href="#" data-bg-src="' . $stars_image . '" data-for="5" class="lazyload"></a>
            <a href="#" data-bg-src="' . $stars_image . '" data-for="4" class="lazyload"></a>
            <a href="#" data-bg-src="' . $stars_image . '" data-for="3" class="lazyload"></a>
            <a href="#" data-bg-src="' . $stars_image . '" data-for="2" class="lazyload"></a>
            <a href="#" data-bg-src="' . $stars_image . '" data-for="1" class="lazyload"></a>
        </div>
        <select name="rating" id="rating">
            <option value="">' . esc_html__( 'Rate&hellip;', 'woocommerce' ) . '</option>
            <option value="5">' . esc_html__( 'Perfect', 'woocommerce' ) . '</option>
            <option value="4">' . esc_html__( 'Good', 'woocommerce' ) . '</option>
            <option value="3">' . esc_html__( 'Average', 'woocommerce' ) . '</option>
            <option value="2">' . esc_html__( 'Not that bad', 'woocommerce' ) . '</option>
            <option value="1">' . esc_html__( 'Very poor', 'woocommerce' ) . '</option>
        </select>
    </div>';
}

$comment_form['comment_field'] .= '<input type="hidden" name="type" value="review">';

$comment_form['submit_button'] = '<p class="comment-form-comment"><label for="comment">' . $review_label . '&nbsp;<span class="required">*</span></label><textarea id="comment" name="comment"></textarea></p>';

if((current_user_can('editor') || current_user_can('administrator'))):
    ?><script> window.is_admin = true </script><?php 
else:
    // attachment input
    $comment_form['submit_button'] .= '<label for="attachments">' . $file_label . '</label><input type="file" name="attachments[]" id="attachments" accept="image/x-png,image/gif,image/jpeg" multiple>';
endif;

$comment_form['fields']['cookies'] = '';

// submit button
$comment_form['submit_button'] .= '<input name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s" />';

comment_form( apply_filters( 'woocommerce_product_review_comment_form_args', $comment_form ), intval(App\Storage::get('queried_object_id')) );
?>
<div class="product_page_loading" id="review_post_loading">
    <i class="far fa-circle-notch fa-spin"></i>
    <div class="success">
        <i class="fas fa-heart"></i>
        <h4><?=$reviews_success_title?></h4>
        <p><?=$reviews_success_message?></p>
    </div>
</div>