<?php 
if(!defined('ABSPATH')){
	exit;
}

$site_logo_thumb = wp_get_site_logo('small');
$reviews_list_data = get_field('product_reviews_list', 'option');

if($reviews_list_data){
    $reviews_verified_text = strval($reviews_list_data['verified_customer_text']);
    $reviews_show_more_text = strval($reviews_list_data['show_more_text']);
    $reviews_share_text = strval($reviews_list_data['share_text']);
} else {
    $reviews_verified_text = '';
    $reviews_show_more_text = '';
    $reviews_share_text = '';
}

$stars_image = msb_get_image_url(get_field('stars_image', 'option'), 'thumbnail');
$product_permalink = strval(get_permalink(App\Storage::get('queried_object_id')));

?>
<div class="comment_list_app">
    <div class="comment_list_app_content" id="review_list_content"></div>
    <div class="comment_list_app_content_show_more">
        <a href="#" id="reviews_list_showmore"><?=$reviews_show_more_text?></a>
    </div>
    <div class="product_page_loading" id="review_list_loading">
        <i class="far fa-circle-notch fa-spin"></i>
    </div>
</div>
<script>
window.review_list_app_props = {
    answer_thumb_url: <?=json_encode($site_logo_thumb)?>,
    product_link: <?=json_encode($product_permalink)?>,
    share_text: <?=json_encode($reviews_share_text)?>,
    verified_text: <?=json_encode($reviews_verified_text)?>,
    stars_image: <?=json_encode($stars_image)?>
}
</script>