<?php 
if (!defined('ABSPATH')){
	exit;
}
$product_id = App\Storage::get('queried_object_id');
$msb_product = msb_get_product($product_id);
?>
<div class="product_page_main_payment_extra">
    <?php foreach($msb_product->get_variation_attributes() as $attributes): ?>
        <label for="attribute_<?=$attributes['key']?>"><?=$attributes['label']?></label>
        <div class="product_page_main_payment_extra_area">
            <select name="attribute_<?=$attributes['key']?>" id="attribute_<?=$attributes['key']?>">
                <?php foreach($attributes['terms'] as $term): ?>
                    <option value="<?=$term['slug']?>" <?=$term['chosen'] ? 'selected="selected"' : ''?> data-image="<?=$term['image']?>" data-text="<?=$term['description']?>"><?=$term['name']?></option>
                <?php endforeach ?>
            </select>
            <div class="product_page_main_payment_extra_desc" data-for="<?='attribute_' . $attributes['key']?>">
                <i class="fas fa-question"></i>
                <div class="product_page_main_payment_extra_desc_content">
                    <div class="image"></div>
                    <div class="text"></div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
    <?php if($msb_product->get_default_carriers()): ?>
        <label><?=App\Acf::get('msb_product_carriers_label', 'option', 'string')?> <b style="color: red;">*</b></label>
        <ul id="product_page_chosen_carriers"></ul>
        <div class="product_page_main_payment_extra_area">
            <div class="product_page_main_payment_extra_area_carriers">
                <input type="text" id="product_carriers" placeholder="<?=App\Acf::get('msb_product_carriers_placeholder', 'option', 'string')?>" required>
                <ul id="product_carriers_suggested"></ul>
            </div>
            <div class="product_page_main_payment_extra_desc">
                <i class="fas fa-question"></i>
            </div>
        </div>
    <?php endif; ?>
</div>
<script>
    window.product_variation_app_props = <?=$msb_product->get_json_variations()?>,
    window.product_carriers = <?=json_encode($msb_product->get_default_carriers())?>
</script>