<?php
if (!defined('ABSPATH')){
	exit;
}
$posts = get_posts(array(
  'category'    => $this->getData('post_category'),
  'post_type'   => 'post',
  'numberposts' => $this->getData('posts_number'),
  'orderby' => 'date',
  'order' => 'DESC'
));
$post_link_text = App\Acf::get('blog_page_post_link_text', 'option', 'str');
?>
<section class="blog_list_page grid">
  <ul class="blog_list_page_list">
    <?php 
    foreach($posts as $post){
    $post_title = $post->post_title;
    $post_image = msb_get_image_url(get_post_thumbnail_id($post->ID), 'medium');
    $post_excerpt = get_the_excerpt($post->ID);
    ?>
    <li>
      <div class="side">
        <a href="<?=the_permalink($post->ID)?>"><img data-src="<?=$post_image?>" alt="<?=$post_title?>" class="lazyload"></a>
      </div>
      <div class="main">
        <a href="<?=the_permalink($post->ID)?>">
          <h2><?=$post_title?></h2>
        </a>
        <div>
          <p><?=$post_excerpt?></p>
        </div>
        <a href="<?=the_permalink($post->ID)?>"><?=$post_link_text?></a>
      </div>
    </li>
  <?php 
  } 
  ?>
  </ul>
  <div class="blog_list_page_load_element">
    <div class="blog_list_page_loading_element">
      <i class="far fa-circle-notch fa-spin"></i>
    </div>
  </div>
</section>
<script type='text/javascript'>
window.blogCategory = <?=$this->getData('post_category')?>;
window.blogPostPerPage = <?=$this->getData('posts_number')?>;
window.blogPostLinkText = <?=json_encode($post_link_text)?>;
</script>