<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$post_featured_image_id = get_post_thumbnail_id(get_the_ID());
$post_featured_image = msb_get_image_url($post_featured_image_id, 'full');
$post_content = apply_filters('the_content', get_the_content('', '', get_the_ID()));

$post_comments = array_filter(get_comments(array(
  'post_id' => get_the_ID()
)), function($comment){
  if(boolval($comment->comment_approved)) return $comment;
});
?>
<section class="blog_post_page">
    <div class="grid">
      <h1 class="blog_post_page_title"><?=get_the_title()?></h1>
      <?php if(boolval($post_featured_image)): ?>
      <div class="image_loader">
        <img class="blog_post_page_image lazyload" data-src="<?=$post_featured_image?>" alt="<?=$post_title?>">
      </div>
    <?php endif; ?>
    </div>
    <div class="blog_post_page_content">
      <div class="grid"><?=$post_content?></div>
    </div>
    <div class="blog_post_page_comments">
      <?php if(!empty($post_comments)): ?>
      <div class="grid">
        <h2 class="blog_post_page_comments_title"><?=__('Comments', 'booster')?>:</h2>
        <ul class="blog_post_page_comments_list">
        <?php 
        foreach($post_comments as $comment):
            $avatar = get_avatar_url($comment->comment_author_email);
            $author_url = $comment->comment_author_url;
            $author_name = $comment->comment_author;
            $comment_id = $comment->comment_ID;
            $comment_date = date('m.d.y', strtotime($comment->comment_date));
            $comment_content = $comment->comment_content;
            $author_tag = array(
              boolval($author_url) ? '<a href="' . $author_url . '" target="_blank" class="blog_post_page_comment_author">' :
                            '<span class="blog_post_page_comment_author">',
              boolval($author_url) ? '</a>' :
                            '</span>'
            )
          ?>
          <li id="comment-<?=$comment_id?>">
            <div class="blog_post_page_comment_side">
              <img data-src="<?=$avatar?>" class="lazyload" alt="<?=$author_name?>">
            </div>
            <div class="blog_post_page_comment_main">
              <header class="blog_post_page_comment_header">
              <?=$author_tag[0] . $author_name . $author_tag[1]?>
                <span class="blog_post_page_comment_date">
                  <i class="fas fa-calendar-alt"></i>
                  <?=$comment_date?>
                </span>
              </header>
              <div class="blog_post_page_comment_content"><?=$comment_content?></div>
              <a href="#" class="blog_post_page_comment_reply_toggle"><?=__('Reply', 'booster')?></a>
            </div>
          </li>
        <?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>
      <div class="blog_post_page_comment_form">
        <div class="grid"><?php
          $comment_author = wp_get_current_commenter();
          $text_settings = App\Acf::get('blog_post_comment', 'option', 'arr');
          comment_form(array(
            'fields' => array(
              'cookies' => '',
              'author' =>
                '<label for="author">' . $text_settings['name'] . '*:</label>' .
            				'<input id="author" name="author" type="text" value="' . esc_attr($comment_author['comment_author']) . '" />',
              'email'  =>
                '<label for="email">' . $text_settings['email'] . '*:</label>' .
            				'<input id="email" name="email" type="text" value="' . esc_attr(  $comment_author['comment_author_email'] ) . '" />',
              'url'    =>
                '<label for="url">' . $text_settings['website'] . '*:</label>' .
            				'<input id="url" name="url" type="text" value="' . esc_attr($comment_author['comment_author_url']) . '" />',
            ),
            'label_submit' => $text_settings['submit'],
            'comment_notes_before' => '',
            'title_reply' => '<h3 class="blog_post_page_comments_title">' . $text_settings['leave_a_reply'] . ':</h3>',
            'comment_field' =>
              '<label for="comment">' . $text_settings['message'] . '*:</label>' .
                      '<textarea name="comment" id="message"></textarea>',
            'id_form' => 'blog_post_page_comment_form',
            'logged_in_as' => ''
          ));
          ?></div>
    </div>
  </div>
</section>
