<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$section_posts = get_posts(array(
    'category'    => $this->getData('post_category'),
    'post_type'   => 'post',
    'numberposts' => -1
  ), 'arr');

if($section_posts): ?>
  <section class="case_study_page grid">
    <h1 class="case_study_page_title"><?=get_the_title()?></h1>
    <ul class="case_study_page_list">
      <?php foreach($section_posts as $post):
        $post_title = $post->post_title;
        $post_link = get_permalink($post->ID);
        $post_featured_image = msb_get_image_url(get_post_thumbnail_id($post->ID), 'medium');
        $post_problem = get_the_excerpt($post->ID);
      ?>
      <li>
        <a href="<?=$post_link?>" data-bg-src="<?=$post_featured_image?>" class="lazyload">
          <div class="case_study_page_list_content">
            <h3 class="case_study_page_list_content_title"><?=$post_title?></h3>
            <p class="case_study_page_list_content_text"><?=$post_problem?></p>
          </div>
        </a>
      </li>
    <?php endforeach ?>
    </ul>
  </section>
<?php endif ?>