<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<section class="case_study_single_page grid">
  <ul class="case_study_single_page_list">
    <li class="case_study_single_page_list_title">
      <?php 
      if($this->getData('the_problem_image')){
        ?>
        <div class="case_study_single_page_thumb">
          <span></span>
          <img data-src="<?=msb_get_image_url($this->getData('the_problem_image'))?>" class="lazyload" alt="<?=$this->getData('the_problem_title')?>">
        </div>
        <?php
      }
      ?>
      <h1><?=get_the_title()?></h1>
    </li>
    <li class="case_study_single_page_list_problem">
      <div>
        <h2><?=$this->getData('the_problem_title')?>:</h2>
        <p><?=apply_filters('the_content', $this->getData('the_problem'))?></p>
      </div>
    </li>
    <li class="case_study_single_page_list_solution">
      <?php if($this->getData('the_solution')): ?>
      <div>
        <h2><?=$this->getData('the_solution_title', 'str')?>:</h2>
        <p><?=apply_filters('the_content', $this->getData('the_solution'))?></p>
        <?php 
        if($this->getData('the_solution_image', 'bool')): 
        ?>
          <img data-src="<?=msb_get_image_url($this->getData('the_solution_image'))?>" class="lazyload" alt="<?=$this->getData('the_solution_title', 'str')?>">
        <?php 
        endif;
        ?>
      </div>
    <?php endif; ?>
    </li>
    <li class="case_study_single_page_list_result">
      <?php 
      if($this->getData('the_result')):
        if($this->getData('the_result_image')){
          ?>
          <div class="case_study_single_page_thumb">
            <img data-src="<?=msb_get_image_url($this->getData('the_result_image'))?>" class="lazyload" alt="<?=$this->getData('the_result_title')?>">
          </div>
          <?php
        }
        ?>
        <h2><?=$this->getData('the_result_title')?>:</h2>
        <p><?=apply_filters('the_content', $this->getData('the_result'))?></p>
      <?php
      endif;
      if($this->getData('section_cta_link')): 
      ?>
      <a href="<?=$this->getData('section_cta_link')?>" class="case_study_single_page_cta"><?=$this->getData('section_cta_link_text')?></a>
    <?php endif;  ?>
    </li>
  </ul>
</section>
