<?php 
if(!defined('ABSPATH')){
	exit;
}
?>
<section class="certified_section">
	<ul class="certified_section_content grid">
		<?php 
		if(isset($this->getData('section_certificates')[0])):
			$src = msb_get_image_url($this->getData('section_certificates')[0], 'full');
			$alt = get_post_meta($this->getData('section_certificates')[0], '_wp_attachment_image_alt', true);
			?>
			<li class="certified_section_content_side">
				<img data-src="<?=$src?>" class="lazyload" alt="<?=$alt?>">
			</li>
			<?php
		endif;
		?>
		<li class="certified_section_content_main">
			<h2 class="certified_section_title"><?=$this->getData('section_title')?></h2>
			<h3 class="certified_section_subtitle"><?=$this->getData('section_subtitle')?></h3>
			<div class="custom_content_area_clean"><?=apply_filters('the_content', $this->getData('section_content'))?></div>
			<?php 
			if($this->getData('section_images')):
				?>
				<ul class="certified_section_content_main_list">
				<?php 
				foreach($this->getData('section_images', 'arr') as $image_id): 
					$src = msb_get_image_url($image_id, 'thumbnail');
					$alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
					?>
					<li>
						<img data-src="<?=$src?>" alt="<?=$alt?>" class="lazyload">
					</li>
					<?php 
				endforeach; 
				?>
				</ul>
				<?php
			endif;
			?>
		</li>
		<?php 
		if(isset($this->getData('section_certificates')[1])):
			$src = msb_get_image_url($this->getData('section_certificates')[1], 'full');
			$alt = get_post_meta($this->getData('section_certificates')[1], '_wp_attachment_image_alt', true);
			?>
			<li class="certified_section_content_side">
				<img data-src="<?=$src?>" class="lazyload" alt="<?=$alt?>">
			</li>
			<?php
		endif;
		?>
	</ul>
</section>