<?php
if (!defined('ABSPATH')){
	exit;
}
?>
<section class="entry_section">
	<h2 class="entry_section_subtitle"><?=$this->getData('section_subtitle')?></h2>
	<div class="entry_section_bg lazyload" data-bg-src="<?=msb_get_image_url($this->getData('section_bg_image'), 'full')?>">
		<div class="grid">
			<h1 class="entry_section_title">
				<?php
				echo $this->getData('section_title');
				$arrow_image = msb_get_image_url($this->getData('section_arrow'), 'medium');
				if($arrow_image): ?>
					<i class="lazyload" data-bg-src="<?=$arrow_image?>" alt="<?=$this->getData('section_title')?>"></i>
				<?php endif ?>
			</h1>
			<ul class="entry_section_by_use_list"><?php
				$categories = $this->getData('section_categories', 'arr');
				if($categories){
					foreach($categories as $category){
						$name = $category->name;
						$permalink = get_category_link($category->term_id);
						$thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
						$thumbnail = msb_get_image_url($thumbnail_id, 'thumbnail');
						?><li>
							<a href="<?=$permalink?>"><i class="lazyload" data-bg-src="<?=$thumbnail?>"></i><?=$name?></a>
						</li><?php
					}
				}

			?></ul>
			<div class="entry_section_subtext"><?=apply_filters('the_content', $this->getData('section_paragraph'));?></div>
		</div>
	</div>
	<div class="grid">
		<ul class="entry_section_providers_list"><?php
		$categories = $this->getData('section_providers', 'arr');
		if($categories){
			foreach($categories as $category){
				$name = $category->name;
				$permalink = get_category_link($category->term_id);
				$thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
				$thumbnail = msb_get_image_url($thumbnail_id, 'thumbnail');
			?><li>
				<a href="<?=$permalink?>">
					<img data-src="<?=$thumbnail?>" alt="<?=$name?>" class="lazyload">
				</a>
			</li><?php 
			}
		} 
		?></ul>
		<ul class="entry_section_providers_list_small"><?php
		$categories = $this->getData('section_providers_small', 'arr');
		if($categories){
			foreach($categories as $category){
				$name = $category->name;
				$permalink = get_category_link($category->term_id);
				$thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
				$thumbnail = msb_get_image_url($thumbnail_id, 'thumbnail');
			?><li>
				<a href="<?=$permalink?>">
					<img data-src="<?=$thumbnail?>" alt="<?=$name?>" class="lazyload">
				</a>
			</li><?php 
			}
		} 
		?></ul>
	</div>
</section>