<?php
if(!defined('ABSPATH')){
	exit;
}
// get categories
$section_categories = get_term_children($this->getData('post_category'), 'category');
?>
<section class="faq_page grid">
  <h1 class="faq_page_title"><?=$this->getData('section_title')?></h1>
  <ul class="faq_page_contact_list">
    <li>
      <h2><?=$this->getData('contact_us_title')?></h2>
      <a href="tel:<?=App\Acf::get('company_phone', 'option')?>" class="faq_page_phone_link"><i class="fa fa-phone" aria-hidden="true"></i><?=App\Acf::get('company_phone', 'option')?></a>
      <p><?=$this->getData('contact_us_desc')?></p>
    </li>
    <li>
      <h2><?=$this->getData('request_us_title')?></h2>
      <?php if($this->getData('request_us_link', 'bool')): ?>
        <a href="<?=$this->getData('request_us_link')?>" class="faq_page_request_link"><?=$this->getData('request_us_link_text')?></a>
      <?php endif; ?>
      <p><?=$this->getData('request_us_desc')?></p>
    </li>
  </ul>
  <?php 
  if($this->getData('post_category') && $section_categories){
    ?>
    <ul class="faq_page_questions_list">
      <?php 
      foreach($section_categories as $category_id):
        $category = get_term($category_id, 'category');
        $thumbnail = msb_get_image_url(App\Acf::get('category_thumbnail', $category), 'meduim');
        $category_posts = get_posts(array(
          'category'    => $category_id,
          'post_type'   => 'post',
          'numberposts' => -1
        ));
        if($category_posts){
          ?>
          <li>
            <a href="<?=get_permalink($category_posts[0])?>" class="faq_page_question_title">
              <i data-bg-src="<?=$thumbnail?>" class="lazyload"></i>
              <?=$category->name?>
            </a>
            <ul>
            <?php 
            foreach($category_posts as $post){
              ?>
              <li><a href="<?=get_permalink($post)?>"><?=$post->post_title?></a></li>
              <?php
            }
            ?>
            </ul>
          </li>
          <?php
        }
      endforeach;
    }
?>
</section>
