<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$section_categories = get_term_children($this->getData('section_categories'), 'category');
?>
<section class="faq_list_page grid">
  <div class="faq_list_page_search">
    <input type="text" placeholder="<?=$this->getData('search_placeholder')?>" id="faq_list_page_search_input">
    <label for="faq_list_page_search_input" class="faq_list_page_search_status">
      <i class="fas fa-search"></i>
      <i class="far fa-circle-notch fa-spin"></i>
    </label>
    <ul class="faq_list_page_search_output"></ul>
  </div>
  <div class="faq_list_page_content_wrapper">
    <div class="faq_list_page_loading"><i class="far fa-circle-notch fa-spin"></i></div>
    <?php if($section_categories): ?>
    <ul class="faq_list_page_nav">
      <?php 
      foreach($section_categories as $category_id):
        $category = get_term($category_id, 'category');
        $category_title = $category->name;
        $category_link = get_category_link($category_id);
        $has_category = has_category($category_id, get_the_ID());
        $category_posts =  get_posts(array(
          'category'    => $category_id,
          'post_type'   => 'post',
          'numberposts' => -1
        ));
      if($category_posts):
        ?>
        <li>
        <a class="faq_parent_link<?php if($has_category) echo ' active'; ?>" href="#"><?=$category_title?><i class="fa fa-angle-right"></i></a>
        <ul <?php if($has_category) echo 'class="active"'; ?>>
        <?php 
        foreach($category_posts as $post):
            $post_title = $post->post_title;
         ?>
          <li>
            <a href="<?=the_permalink($post->ID)?>" class="faq_link<?php if($post->ID == get_the_ID()) echo ' active'; ?>" data-post-id="<?=$post->ID?>"><?=$post_title?></a>
          </li>
        <?php 
        endforeach; 
        ?>
        </ul>
      </li>
        <?php 
        endif; 
    endforeach; 
    ?>
    </ul>
    <?php
    endif; 
    ?>
    <div class="faq_list_page_content">
      <h1 class="faq_list_page_content_title"><?=get_the_title()?></h1>
      <div class="faq_list_page_content_main"><?=apply_filters('the_content', get_the_content('', '', get_the_ID()))?></div>
    </div>
  </div>
</section>
<script>
  window.currentPost = <?=get_the_ID()?>;
  window.faqCategoryId = <?=$this->getData('section_categories')?>;
</script>