<?php 
if (!defined('ABSPATH')){
	exit;
}
global $WC_booster;
?>
<section class="featured_section">
	<div class="grid">
		<h2 class="featured_section_title"><?=$this->getData('section_title')?></h2>
		<ul class="featured_section_product_list"><?php 
		$products = $this->getData('section_products', 'arr');
		if($products){
			foreach($products as $product_id){
				$wc_product = wc_get_product($product_id);
				$msb_product = msb_get_product($wc_product);
				$featured_image_url = msb_get_image_url($wc_product->get_image_id(), 'medium');
				?>
				<li>
				<?php 
				if($msb_product->is_bestseller()){
					?><span class="featured_section_product_bestseller"><?=$this->getData('section_bestseller_text')?></span><?php
				}
				?>
				<a href="<?=$wc_product->get_permalink()?>" class="featured_section_product_thumb">
					<img data-src="<?=$featured_image_url?>" alt="<?=$wc_product->get_name()?>" class="lazyload">
				</a>
				<header class="featured_section_product_header">
					<a href="<?=$wc_product->get_permalink()?>" class="featured_section_product_title"><?=$wc_product->get_name()?></a>
					<span class="featured_section_product_price">
						<?php 
						if($wc_product->is_on_sale()){
							?>
							<del><?=$msb_product->get_regular_price(true)?></del>
							<span><?=$msb_product->get_sale_price(true)?></span>
							<?php
						} else {
							?>
							<span><?=$msb_product->get_regular_price(true)?></span>
							<?php
						}
						?>
					</span>
				</header>
					<ul class="featured_section_product_description">
						<?php if($msb_product->get_coverage()): ?>
							<li>
								<h5 class="featured_section_product_description_title"><?=$WC_booster->wc_get_categories_label('coverage')?>:</h5>
								<p class="featured_section_product_description_content"><?=$msb_product->get_coverage()?></p>
							</li>
							<?php
						endif;
						if($msb_product->get_ideal_for()): ?>
							<li>
								<h5 class="featured_section_product_description_title"><?=$WC_booster->wc_get_categories_label('by_use')?>:</h5>
								<ul class="featured_section_product_description_content_list_by_use">
								<?php foreach($msb_product->get_ideal_for() as $category):
									$name = $category->name;
									$thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
									$thumbnail = msb_get_image_url($thumbnail_id, 'small_thumbnail');
								?>
								<li>
									<i class="featured_section_product_description_by_use_icon lazyload" title="<?=$name?>" data-bg-src="<?=$thumbnail?>"></i>
								</li>
								<?php endforeach;
								?>
								</ul>
							</li>
						<?php endif ?>
						<?php if($msb_product->get_providers()): ?>
						<li>
							<h5 class="featured_section_product_description_title"><?=$WC_booster->wc_get_categories_label('providers')?>:</h5>
							<ul class="featured_section_product_description_content_list_providers">
							<?php foreach($msb_product->get_providers() as $category):
								$name = $category->name;
								$thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
								$thumbnail = msb_get_image_url($thumbnail_id, 'small_thumbnail');
								?>
								<li>
									<i class="featured_section_product_description_provider_icon lazyload" title="<?=$name?>" data-bg-src="<?=$thumbnail?>"></i>
								</li>
								<?php endforeach ?>
							</ul>
						</li>
						<?php endif ?>
					</ul>
					<div class="featured_section_product_links">
						<a href="<?=$wc_product->get_permalink()?>" class="featured_section_product_info_link"><?=$this->getData('view_more_link_text', 'str')?></a>
					</div>
				</li>
			<?php 
			}
		}	
		?>
		</ul>
		<?php if($this->getData('section_cta_link')): ?>
			<a href="<?=get_permalink($this->getData('section_cta_link'))?>" class="featured_section_shop_link"><?=$this->getData('section_cta_text')?></a>
		<?php endif; ?>
	</div>
</section>