<?php

use App\Storage;

/**
 * Function to get categories
 * 
 * Yield stuff to be rendered and loop through all filter cateogires
 * to pass all the needles to javascript application that renderes
 * child cateogries and handles features like multiselect|highlight bestsellers
 * 
 * @var array $filter_section_categories
 * 
 * @return Generator
 */
$this->setFunc('get_filter_categories', function(){
    if($this->getData('categories', 'arr')){
        $to_return = [];
        $json_data = [];
        foreach($this->getData('categories', 'arr') as $key=>$categories){
            $to_yield = [
                'step_id' => 'filter_step_' . ($key + 1),
                'title' => $categories['categories_title'] ?? '',
                'subtitle' => $categories['categories_subtitle'] ?? '',
                'multiselect' => $categories['multiselect'] ?? false,
                'highlight_bestsellers' => $categories['highlight_bestsellers'] ?? false,
                'categories' => $categories['category_list'] ?? []
            ];
            $to_push = [
                'title' => $categories['categories_title'] ?? '',
                'multiselect' => $categories['multiselect'] ?? false,
                'highlight_bestsellers' => $categories['highlight_bestsellers'] ?? false,
                'categories' => []
            ];
            foreach($categories['category_list'] as $category){
                if($category['category']){
                    $to_push['categories'][$category['category']->term_id] = [
                        "name" => $category['category']->name,
                        "image" => msb_get_image_url(get_term_meta($category['category']->term_id, 'thumbnail_id', true), 'thumbnail'),
                        "description" => $category['category']->description
                    ];
                    if(!$to_push['multiselect'] && $category['sub_categories']){
                        $sub_categories = [
                            "title" => $category['sub_categories_title'],
                            "subtitle" => $category['sub_categories_subtitle'],
                            "categories" => []
                        ];
                        foreach($category['sub_categories'] as $index=>$sub_category){
                            $sub_categories['categories'][$sub_category->term_id] = [
                                "name" => $sub_category->name,
                                "image" => msb_get_image_url(get_term_meta($sub_category->term_id, 'thumbnail_id', true), 'thumbnail'),
                                "description" => $sub_category->description,
                                "index" => $index
                            ];
                        }
                        $to_push['categories'][$category['category']->term_id]['sub_categories'] = $sub_categories;
                    }
                }
            }
            $json_data[$to_yield['step_id']] = $to_push;
            yield $to_yield;
        }
        Storage::set('filter_section_categories', json_encode($json_data));
    } else {
        return [];
    }
});