<?php
if(!defined('ABSPATH')){
	exit;
}

if(get_term_by('id', App\Storage::get('queried_object_id'), 'product_cat')){
  $current_category = App\Storage::get('queried_object');
} else {
  $current_category = NULL;
}

// get products args
$query_args = array(
    'post_type' => 'product',
    'posts_per_page' => 10,
    'tax_query' => array(
        array(
            'taxonomy'      => 'product_cat',
            'terms'         => $this->getData('exclude_categories'),
            'field'         => 'term_id',
            'operator'      => 'NOT IN',
            'include_children' => false
        ),
        array(
					'taxonomy' => 'product_visibility',
					'field'    => 'name',
					'terms'    => array('exclude-from-catalog'),
					'operator' => 'NOT IN',
					'include_children' => false,
				)
    ),
    'orderby' => 'menu_order',
    'order' => 'ASC'
);

// filter query by category if this is a category page
if(boolval($current_category)) $query_args['product_cat'] = $current_category->slug;
$products_query = new WP_Query($query_args);

if($products_query->posts): $stars_image = msb_get_image_url(App\Acf::get('stars_image', 'option', 'int'), 'thumbnail'); ?>
  <section class="shop_page grid">
    <?php if($this->getData('categories')): ?>
      <div class="shop_page_filter_container">
        <ul class="shop_page_filter">
          <?php foreach($this->callFunc('get_filter_categories') as $category_list): ?>
            <li data-categories-id="<?=$category_list['step_id']?>">
              <h2>
                <?=$category_list['title'] ?>
                <i class="lazyload" data-bg-src="<?=msb_get_image_url($this->getData('arrow_image'), 'thumbnail')?>" alt="<?=$category_list['title']?>"></i>
              </h2>
              <?=$category_list['subtitle'] ? '<span>' . $category_list['subtitle'] . '</span>' : ''?>
              <ul>
              <?php foreach($category_list['categories'] as $category): ?>
                <li>
                  <a href="#" data-category-id="<?=$category['category']->term_id?>">
                    <i class="lazyload" data-bg-src="<?=msb_get_image_url(get_term_meta($category['category']->term_id, 'thumbnail_id', true), 'thumbnail')?>"></i>
                    <h4><?=$category['category']->name?></h4>
                    <?=$category['category']->description ? '<p>' . $category['category']->description . '</p>' : ''?>
                  </a>
                </li>
              <?php endforeach ?>
              </ul>
            </li>
          <?php endforeach ?>
        </ul>
        <a href="#" class="shop_page_filter_back_button"><?=$this->getData('back_button_text')?></a>
      </div>
    <?php endif ?>
    <ul class="shop_page_products">
      <?php 
      // if highlight bestseller products variable
      $highlight_bestsellers = isset($this->getData('categories')[0]) && $this->getData('categories')[0]['highlight_bestsellers'];
      foreach($products_query->posts as $post): $msb_product = msb_get_product($post->ID); ?>
        <li class="<?=$msb_product->is_bestseller() && $highlight_bestsellers ? 'bestseller' : ''?>">
            <div class="image">
                <?php if($msb_product->wc()->is_on_sale() && $this->getData('section_sale_text', 'str')): ?>
                    <div class="sale"><?=$this->getData('section_sale_text')?></div>
                <?php endif ?>
                <a href="<?=$msb_product->wc()->get_permalink()?>"><img data-src="<?=msb_get_image_url(get_post_thumbnail_id($post->ID), 'medium')?>" class="lazyload" alt="<?=$msb_product->wc()->get_name()?>"></a>
                <?php if($msb_product->is_bestseller() && $highlight_bestsellers && $this->getData('section_bestseller_text')): ?>
                    <div class="free"><?=$this->getData('section_bestseller_text')?></div>
                <?php endif ?>
            </div>
            <div class="main">
                <?php if($msb_product->wc()->get_reviews_allowed()): ?>
                    <div class="rating lazyload" data-bg-src="<?=$stars_image?>"><span style="width: <?=$msb_product->get_average_rating() * 20?>%;" class="lazyload" data-bg-src="<?=$stars_image?>"></span></div>
                    <div class="reviews"><?=$msb_product->get_reviews_count()?> <?=$this->getData('section_review_text')?></div>
                    <?php endif ?>
                <?php if($msb_product->is_bestseller() && $highlight_bestsellers): ?>
                  <div class="choice"><?=$this->getData('section_bestseller_yellow_text', 'str')?></div>
                <?php endif ?>
                <div class="title">
                    <a href="<?=$msb_product->wc()->get_permalink()?>"><?=$msb_product->wc()->get_name()?></a>
                </div>
            </div>
            <div class="coverage"><?=$msb_product->get_coverage()?></div>
            <ul class="by-use">
              <?php if($msb_product->get_ideal_for()):
                    foreach($msb_product->get_ideal_for() as $category):
                      $name = $category->name;
                      $thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                      $thumbnail = msb_get_image_url($thumbnail_id, 'small_thumbnail');
                      ?>
                      <li><i class="lazyload" data-bg-src="<?=$thumbnail?>" title="<?=$name?>"></i></li>
                    <?php endforeach;
              endif ?>
            </ul>
            <ul class="providers">
              <?php if($msb_product->get_providers()):
                    foreach($msb_product->get_providers() as $category):
                      $name = $category->name;
                      $thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                      $thumbnail = msb_get_image_url($thumbnail_id, 'small_thumbnail');
                      ?>
                      <li><img class="lazyload" data-src="<?=$thumbnail?>" alt="<?=$name?>"></li>
                    <?php endforeach;
              endif ?>
            </ul>
            <div class="application">
                <div class="band">
                  <?php if($msb_product->has_band()): ?>
                    <span style="background-color: <?=$msb_product->get_band_color()?>;"><?=$msb_product->get_band_name()?></span>
                  <?php endif ?>
                </div>
                <div class="gsm">
                    <span><?=$msb_product->get_gsm()?></span>
                </div>
            </div>
            <div class="price_nd_link">
                <div class="price">
                  <?php if($msb_product->wc()->is_on_sale()): ?>
                    <del><?=$msb_product->get_regular_price(true)?></del>
                    <span><?=$msb_product->get_sale_price(true)?></span>
                    <strong><?=$this->getData('section_sale_save_text') . ' ' . wc_price($msb_product->get_regular_price() - $msb_product->get_sale_price()) ?></strong>
                  <?php else: ?>
                    <span><?=$msb_product->get_regular_price(true)?></span>
                  <?php endif ?>
                </div>
                <div class="link">
                    <a href="<?=$msb_product->wc()->get_permalink()?>"><?=$this->getData('section_product_link_text')?></a>
                </div>
            </div>
        </li>
        <?php
        // hightlight only first bestseller
        if($highlight_bestsellers && $msb_product->is_bestseller()){
            $highlight_bestsellers = false;
        }
      endforeach ?>
    </ul>
    <div class="shop_page_loading">
      <i class="far fa-circle-notch fa-spin"></i>
    </div>
  </section>
  <script>
    window.shop_app_vars = {
      initial_highlight_bestsellers: <?=json_encode(isset($highlight_bestsellers) && $highlight_bestsellers) // highlight bestsellers with pagination first step?>,
      current_category_id: <?=boolval($current_category) ? $current_category->term_id : 'undefined'?>,
      category_list: <?=App\Storage::get('filter_section_categories') // see filter functions categories generator function ?>,
      star_image: <?=json_encode($stars_image ?? '')?>,
      sale_text: <?=json_encode($this->getData('section_sale_text', 'str'))?>,
      review_text: <?=json_encode($this->getData('section_review_text'))?>,
      bestseller_text: <?=json_encode($this->getData('section_bestseller_text'))?>,
      bestseller_yellow_text: <?=json_encode($this->getData('section_bestseller_yellow_text'))?>,
      product_link_text: <?=json_encode($this->getData('section_product_link_text'))?>,
      sale_save_text: <?=json_encode($this->getData('section_sale_save_text'))?>,
      categories_exclude: <?=json_encode($this->getData('exclude_categories', 'arr'))?>,
      arrow_image: <?=json_encode($arrow_image ?? '') ?>
    }
  </script>
<?php endif ?>