<?php
if (!defined('ABSPATH')){
	exit;
}
?>
<section class="installation_page">
  <div class="grid">
    <h1 class="installation_page_title"><?=$this->getData('section_title')?></h1>
    <?php if($this->getData('section_youtube')): ?>
    <iframe src="<?=$this->getData('section_youtube')?>" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
    <?php endif ?>
    <?php if($this->getData('section_steps')): ?>
      <ul class="installation_page_steps">
        <?php
        foreach($this->getData('section_steps') as $step):
        ?>
        <li>
          <div class="content">
            <h4><?=$step['title']?></h4>
            <div><?=apply_filters('the_content', $step['content'])?></div>
          </div>
          <?php
          if(count($step['images']) == 1){
            $image = msb_get_image_url($step['images'][0], 'medium');
          ?><img data-src="<?=$image?>" class="lazyload" alt="<?=$step['title']?>">
          <?php 
          } elseif(count($step['images']) > 1){ 
          ?>
          <div class="installation_page_steps_slider_container">
            <ul class="installation_page_steps_slider">
              <?php foreach($step['images'] as $image_id):
                  $image = msb_get_image_url($image_id, 'medium');
                ?><li><img src="<?=$image?>" class="<?=$step['title']?>"></li><?php
              endforeach; ?>
            </ul>
          </div>
        <?php }
      endforeach; ?>
    </ul>
  <?php endif; ?>
  </div>
</section>
