<?php
if (!defined('ABSPATH')){
	exit;
}

if(get_term_by('id', App\Storage::get('queried_object_id'), 'product_cat')){
  $current_category = App\Storage::get('queried_object');
} else {
  $current_category = NULL;
}

// get products args
$query_args = array(
    'post_type' => 'product',
    'posts_per_page' => -1,
    'tax_query' => array(
        array(
            'taxonomy'      => 'product_cat',
            'terms'         => $this->getData('exclude_categories'),
            'field'         => 'term_id',
            'operator'      => 'NOT IN',
            'include_children' => false
        ),
        array(
            'taxonomy' => 'product_visibility',
            'field'    => 'name',
            'terms'    => array('exclude-from-catalog'),
            'operator' => 'NOT IN',
            'include_children' => false,
        )
    ),
    'orderby' => 'menu_order',
    'order' => 'ASC'
);

// filter query by category if this is a category page
if($current_category) $query_args['product_cat'] = $current_category->slug;

// get products
$products_query = new WP_Query($query_args);
$products = $products_query->posts;

if($products){
    global $WC_booster;
    $stars_image = msb_get_image_url(App\Acf::get('stars_image', 'option', 'int'), 'thumbnail');
    $highlight_bestsellers = $this->getData('section_hightlight_bestsellers', 'bool');
    ?>
    <div class="grid">
        <ul class="shop_page_products">
        <?php 
        foreach($products as $product){
            $wc_product = wc_get_product($product->ID);
            $msb_product = new App\Product($wc_product, $WC_booster);
            $bestseller_class = $msb_product->is_bestseller() && $highlight_bestsellers ? 'bestseller' : '';
            $featured_image = msb_get_image_url(get_post_thumbnail_id($product->ID), 'medium');
            ?>
            <li class="<?=$bestseller_class?>">
                <div class="image">
                    <?php 
                    if($wc_product->is_on_sale() && $this->getData('section_sale_text', 'str')){
                        ?><div class="sale"><?=$this->getData('section_sale_text')?></div><?php
                    } 
                    ?>
                    <a href="<?=$wc_product->get_permalink()?>"><img data-src="<?=$featured_image?>" class="lazyload" alt="<?=$wc_product->get_name()?>"></a>
                    <?php 
                    if($msb_product->is_bestseller() && $highlight_bestsellers && $this->getData('section_bestseller_text')){
                        ?><div class="free"><?=$this->getData('section_bestseller_text')?></div><?php
                    }
                    ?>
                </div>
                <div class="main">
                    <?php 
                    if($wc_product->get_reviews_allowed()){
                        ?>
                        <div class="rating lazyload" data-bg-src="<?=$stars_image?>"><span style="width: <?=$msb_product->get_average_rating() * 20?>%;" class="lazyload" data-bg-src="<?=$stars_image?>"></span></div>
                        <div class="reviews"><?=$msb_product->get_reviews_count()?> <?=$this->getData('section_review_text')?></div>
                        <?php
                    }
                    if($msb_product->is_bestseller() && $highlight_bestsellers){
                        ?><div class="choice"><?=$this->getData('section_bestseller_yellow_text', 'str')?></div><?php
                    } 
                    ?>
                    <div class="title">
                        <a href="<?=$wc_product->get_permalink()?>"><?=$wc_product->get_name()?></a>
                    </div>
                </div>
                <div class="coverage"><?=$msb_product->get_coverage()?></div>
                <ul class="by-use"><?php
                    if($msb_product->get_ideal_for()){
                        foreach($msb_product->get_ideal_for() as $category){
                            $name = $category->name;
                            $thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                            $thumbnail = msb_get_image_url($thumbnail_id, 'small_thumbnail');
                            ?>
                            <li><i class="lazyload" data-bg-src="<?=$thumbnail?>" title="<?=$name?>"></i></li>
                            <?php
                        }
                    }
                ?></ul>
                <ul class="providers"><?php
                    if($msb_product->get_providers()){
                        foreach($msb_product->get_providers() as $category){
                            $name = $category->name;
                            $thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                            $thumbnail = msb_get_image_url($thumbnail_id, 'small_thumbnail');
                            ?>
                            <li><img class="lazyload" data-src="<?=$thumbnail?>" alt="<?=$name?>"></li>
                            <?php
                        }
                    }
                ?></ul>
                <div class="application">
                    <div class="band"><?php 
                        if($msb_product->has_band()){
                            ?><span style="background-color: <?=$msb_product->get_band_color()?>;"><?=$msb_product->get_band_name()?></span><?php
                        }
                    ?></div>
                    <div class="gsm">
                        <span><?=$msb_product->get_gsm()?></span>
                    </div>
                </div>
                <div class="price_nd_link">
                    <div class="price">
                    <?php 
                    if($wc_product->is_on_sale()){
                        ?>
                        <del><?=$msb_product->get_regular_price(true)?></del>
                        <span><?=$msb_product->get_sale_price(true)?></span>
                        <strong><?=$this->getData('section_sale_save_text') . ' ' . wc_price($msb_product->get_regular_price() - $msb_product->get_sale_price()) ?></strong>
                        <?php
                    } else {
                        ?>
                        <span><?=$msb_product->get_regular_price(true)?></span>
                        <?php
                    }
                    ?>
                    </div>
                    <div class="link">
                        <a href="<?=$wc_product->get_permalink()?>"><?=$this->getData('section_product_link_text')?></a>
                    </div>
                </div>
            </li>
            <?php
            // hightlight only first bestseller
            if($highlight_bestsellers && $msb_product->is_bestseller()){
                $highlight_bestsellers = false;
            }
        }
        ?>
        </ul>
    </div>
    <?php
}
?>