<?php 
if(!defined('ABSPATH')){
	exit;
}

$shortcode_props = App\Storage::get('shortcode_props');
global $WC_booster;
// get category list
$categories = $WC_booster->wc_get_categories($shortcode_props['categories']);
if(!empty($categories)):
    // centered class
    $centered_class = $shortcode_props['centered'] ? 'centered' : '';
    // title
    if($shortcode_props['title']):
        ?><h1 class="page_title <?=$centered_class?>"><?=$shortcode_props['title']?></h1><?php
    endif;
    // styles switch
    switch($shortcode_props['style']){
        // sharp styles used for providers
        case "sharp":
            ?>
            <ul class="browse_section_providers_list <?=$centered_class?>"><?php
                foreach($categories as $category):
                    $category_link = get_category_link($category->term_id);
                    $thumb_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                    $category_thumb = msb_get_image_url($thumb_id, 'thumbnail');
                    $category_color = get_option('cat_background_color'.$category->term_id);
                    ?>
                    <li style="background-color: <?=$category_color?>;"><a href="<?=$category_link?>"><img data-src="<?=$category_thumb?>" class="lazyload" alt="<?=$category->name?>"><span><?=wp_get_category_fullname($category)?></span></a></li>
                    <?php
                endforeach; 
                ?></ul><?php
            break;
        // default styles
        default: 
            ?>
            <ul class="browse_section_by_use_list <?=$centered_class?>"><?php
                foreach($categories as $category):
                    $thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                    ?><li><a href="<?=get_category_link($category->term_id)?>"> <i class="lazyload" data-bg-src="<?=msb_get_image_url($thumbnail_id, 'thumbnail')?>"></i><?=wp_get_category_fullname($category)?></a></li><?php
                endforeach; 
            ?></ul><?php
    }
endif;
?>