<?php 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$shortcode_props = App\Storage::get('shortcode_props');

$since = get_field('company_helped_since', 'option');

$per_day = get_field('company_helped_per_day', 'option');

if(!(bool)$since && !(bool)$per_day) return '';

if(!strtotime($since) || !intval($per_day)) return '';

// count customers
$days_passed = round((time() - strtotime($since)) / 86400);

if($shortcode_props['format'] && strval($shortcode_props['format'])){

    echo number_format(round($days_passed * intval($per_day)), 0, strval($shortcode_props['format']), strval($shortcode_props['format']));

} else {

    echo round($days_passed * intval($per_day));

}


?>