<?php 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$post_id = App\Storage::get('queried_object_id');

$wc_product = wc_get_product($post_id);

if(!$wc_product) return '';

$shortcode_props = App\Storage::get('shortcode_props');

$table_title = $shortcode_props['title'];

$table_rows = get_field('technical_specification_list', $post_id);

if(!$table_rows || !is_array($table_rows)) return '';

$table_rows = array_slice($table_rows, intval($shortcode_props['offset']), intval($shortcode_props['offset']) + intval($shortcode_props['items']));

if(!$table_rows) return '';

?>

<ul class="product_page_description_tabs_tech_list">

<?php if($table_title): ?>

<li class="title"><?=$table_title?></li>

<?php endif; ?>

<?php foreach($table_rows as $row){

    $content_type = $row['content_single'];

?>
<li class="row<?=$content_type == 'complex' ? ' sub' : ''?>">

    <header><?=$row['title']?></header>

    <?php if($content_type == 'plain'): ?>

    <div><?=apply_filters('the_content', $row['content'])?></div>

    <?php elseif($content_type == 'complex' && !empty($row['sub_rows'])): ?>
    <ul>
        <?php foreach($row['sub_rows'] as $sub_row){ ?>
            <li>
                <header><?=$sub_row['title']?></header>
                <div><?=apply_filters('the_content', $sub_row['content'])?></div>
            </li>
        <?php } ?>

    </ul>
    <?php endif; ?>

</li>
<?php 

}
?>
</ul>