<?php 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$cart_page_title = get_option('woocommerce_cart_page_id') ? get_the_title(get_option('woocommerce_cart_page_id')) : '';
$checkout_title = get_option('woocommerce_checkout_page_id') ? get_the_title(get_option('woocommerce_checkout_page_id')) : '';
$thanks_page_title = strval(get_field('checkout_thankyou_title', 'option')); 
$active_html = ' class="active"';
?>
<header class="cart_header">
    <div class="grid">
        <ul>
            <li <?php if(is_cart()) echo $active_html ?>>
            <i class="far fa-shopping-cart"></i>
                <p><?=$cart_page_title?></p>
            </li>
            <li <?php if(!is_order_received_page() && is_checkout()) echo $active_html ?>>
                <i class="far fa-lock"></i>
                <p><?=$checkout_title?></p>
            </li>
            <li <?php if(is_order_received_page()) echo $active_html ?>>
                <i class="far fa-truck"></i>
                <p><?=$thanks_page_title?></p>
            </li>
        </ul>
    </div>
</header>