<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.8.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_cart'); ?>
<section class="cart_page grid">
    <header class="cart_page_header">
        <h1 class="cart_page_title"><?= App\Acf::get('cart_title', 'option', 'str') ?></h1>
        <?php if (get_permalink(wc_get_page_id('shop'))): ?>
            <a href="<?= get_permalink(wc_get_page_id('shop')) ?>"
               class="cart_page_cta"><?= App\Acf::get('cart_shop_cta_link_text', 'option', 'str') ?></a>
        <?php endif; ?>
    </header>
    <form class="woocommerce-cart-form" action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post">
        <?php do_action('woocommerce_before_cart_table'); ?>
        <?php

        $extras_title = App\Acf::get('cart_extra', 'option', 'str');

        $price_title = App\Acf::get('cart_price', 'option', 'str');

        $qty_title = App\Acf::get('cart_qty', 'option', 'str');

        ?>

        <ul class="shop_table shop_table_responsive cart woocommerce-cart-form__contents cart_page_product_list"
            cellspacing="0">

                <?php do_action('woocommerce_before_cart_contents'); ?>

                <?php
                foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
                    $_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
                    $product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);

                    if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_cart_item_visible', true, $cart_item, $cart_item_key)) {
                        $product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
                        ?>
                        <!--                <tr class="woocommerce-cart-form__cart-item --><?php //echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?><!--">-->
            <li>
                        <div class="product-remove remove">

                                <a href="<?=wc_get_cart_remove_url($cart_item_key)?>"><i class="fas fa-trash-alt"></i></a>
                        </div>
                        <div class="image">
                            <?php
                            $thumbnail = msb_get_image_url($_product->get_image_id(), 'medium');
                            ?>
                            <a href="<?=$product_permalink?>"><img src="<?=$thumbnail?>" alt="<?=$_product->get_name()?>" >

                            </a>
                        </div>


                        <div class="content">
                            <a href="<?= $product_permalink ?>"><?= $_product->get_name() ?></a>
                            <?php
                            if ($cart_item['data']->is_type('variation') && is_array($cart_item['variation'])):
                                $attibutes_to_print = msb_get_cart_item_attributes($cart_item['variation']);
                                if ($attibutes_to_print):
                                    ?>
                                    <h3><?= $extras_title ?>:</h3>
                                    <ul>
                                        <?php
                                        foreach ($attibutes_to_print as $attribute):
                                            ?>
                                            <li><?= $attribute['label'] ?>: <?= $attribute['value'] ?></li><?php
                                        endforeach;
                                        ?>
                                    </ul>
                                <?php
                                endif;
                                ?>
                            <?php endif ?>
                        </div>

                        <div class="product-price price" data-title="<?php esc_attr_e('Price', 'woocommerce'); ?>">
                            <b><?=$price_title?>:</b> <?=WC()->cart->get_product_price( $_product )?>
                        </div>

                        <div class="product-quantity" data-title="<?php esc_attr_e('Quantity', 'woocommerce'); ?>">
                            <b><?=$qty_title?>:</b>

                            <?php
                            if ($_product->is_sold_individually()) {
                                $product_quantity = sprintf('1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key);
                            } else {
                                $product_quantity = woocommerce_quantity_input(
                                    array(
                                        'input_name' => "cart[{$cart_item_key}][qty]",
                                        'input_value' => $cart_item['quantity'],
                                        'max_value' => $_product->get_max_purchase_quantity(),
                                        'min_value' => '1',
                                        'product_name' => $_product->get_name(),
                                    ),
                                    $_product,
                                    false
                                );
                            }
                            echo apply_filters('woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item); // PHPCS: XSS ok.
                            ?>
                        </div>

                        <div class="product-subtotal total" data-title="<?php esc_attr_e('Subtotal', 'woocommerce'); ?>">
                            <b><?=App\Acf::get('cart_total', 'option', 'str')?>:</b>
                            <?=WC()->cart->get_product_subtotal($_product, $cart_item['quantity'])?>
                        </div>
            </li>
                        <?php
                    }
                }
                ?>

                <?php do_action('woocommerce_cart_contents'); ?>

                <?php do_action('woocommerce_after_cart_contents'); ?>

        </ul>

        <div class="cart_page_total">
            <?php if (wc_coupons_enabled()): ?>
                <div class="cart_page_total_coupon">
                    <label for="coupon_code"><?= App\Acf::get('cart_coupon_title', 'option', 'str') ?></label>
                    <ul>
                        <li><input type="text" name="coupon_code" id="coupon_code" value=""
                                   placeholder="<?= App\Acf::get('cart_coupon_placeholder', 'option', 'str') ?>"/></li>
                        <li>
                            <button type="submit" name="apply_coupon"
                                    value="<?= esc_attr(App\Acf::get('cart_coupon_apply_button', 'option', 'str')) ?>"><?= App\Acf::get('cart_coupon_apply_button', 'option', 'str') ?></button>
                        </li>
                        <?php foreach (WC()->cart->get_coupons() as $code => $coupon) :
                            $coupon_object = new WC_Coupon($coupon);
                            ?>
                            <li class="coupon_item">
                                <strong><?= $coupon_object->get_description() . ' [' . $coupon_object->get_code() . '] ' ?></strong>
                                <?php wc_cart_totals_coupon_html($coupon); ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif;
            ?>

            <button type="submit" class="button" name="update_cart" style="display: none"
                    value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>"><?php esc_html_e('Update cart', 'woocommerce'); ?></button>

            <?php do_action('woocommerce_cart_actions'); ?>

            <?php wp_nonce_field('woocommerce-cart', 'woocommerce-cart-nonce'); ?>

            <?php do_action('woocommerce_after_cart_table'); ?>


             <?php
                do_action('woocommerce_cart_collaterals'); ?>


    </form>

</section>


<?php do_action('woocommerce_after_cart'); ?>
