<?php
/**
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
	return;
}
$page_title = strval(get_field('checkout_title', 'option')); 
$billing_title = strval(get_field('checkout_billing_title', 'option')); 
$shipping_title = strval(get_field('checkout_shipping_title', 'option')); 
$additional_title = strval(get_field('checkout_additional_information_title', 'option')); 
$apply_coupon_text = strval(get_field('checkout_apply_coupon', 'option')); 

?>


<section class="checkout_page grid">
	<h2 class="checkout_page_title"><?=$page_title?></h2>
	<?php do_action( 'woocommerce_before_checkout_form', $checkout ); ?>
	<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
		<div class="checkout_page_content">
			<div>
			<?php if($checkout->get_checkout_fields()): ?>
				<ul class="checkout_page_content_steps">
					<li>
						<h2 class="checkout_page_content_steps_title"><span>1</span><?=$billing_title?></h2>
						<div class="inner_grid">
							<?php do_action( 'woocommerce_checkout_billing' ); ?>
						</div>
					</li>
					<?php if(true === WC()->cart->needs_shipping_address()):  ?>
					<li>
						<h2 class="checkout_page_content_steps_title"><span>2</span><?=$shipping_title?></h2>
						<div class="inner_grid">
							<?php do_action( 'woocommerce_checkout_shipping' ); ?>
						</div>
					</li>
					<?php 
							
					endif; 
							
					if($checkout->get_checkout_fields('order') && $checkout->get_checkout_fields('order')['order_comments']): 
					
					?>
					<li>
						<h2 class="checkout_page_content_steps_title"><span>3</span><?=$additional_title?></h2>
						<div class="inner_grid">
							<div class="rowspan">
							<?= wp_get_checkout_field_html('order_comments', $checkout->get_checkout_fields('order'), $checkout); ?>
							</div>
						</div>
					</li>
					<?php endif; ?>
				</ul>
			<?php endif; ?>
			</div>
			<div class="sticky">
				<div class="inner_grid">
					<div class="rowspan">
						<a href="#" class="coupon_toggle showcoupon"><?=$apply_coupon_text?></a>
					</div>
					<div class="rowspan">
					<?php do_action( 'woocommerce_checkout_order_review' ); ?>
				</div>
			</div>
		</div>
	</form>
	<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
</section>