<?php
/**
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 * @global WC_Checkout $checkout
 */

defined( 'ABSPATH' ) || exit;

$add_shipping_text = strval(get_field('checkout_add_shipping_address', 'option'));

$fields = $checkout->get_checkout_fields('shipping');
	
?>
<div id="ship-to-different-address" class="rowspan">
	<input id="ship-to-different-address-checkbox" class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" <?php checked( apply_filters( 'woocommerce_ship_to_different_address_checked', 'shipping' === get_option( 'woocommerce_ship_to_destination' ) ? 1 : 0 ), 1 ); ?> type="checkbox" name="ship_to_different_address" value="1" />
	<label for="ship-to-different-address-checkbox"><?=$add_shipping_text?></label>
</div>
<div class="inner_grid shipping_address">
	<div class="row"><?= wp_get_checkout_field_html('shipping_first_name', $fields, $checkout); ?></div>
	<div class="row"><?= wp_get_checkout_field_html('shipping_last_name', $fields, $checkout); ?></div>
	<div class="rowspan"><?= wp_get_checkout_field_html('shipping_company', $fields, $checkout); ?></div>
	<div class="rowspan"><?= wp_get_checkout_field_html('shipping_city', $fields, $checkout); ?></div>
	<div class="rowspan"><?= wp_get_checkout_field_html('shipping_country', $fields, $checkout); ?></div>
	<div class="rowspan"><?= wp_get_checkout_field_html('shipping_address_1', $fields, $checkout); ?></div>
	<div class="rowspan"><?= wp_get_checkout_field_html('shipping_address_2', $fields, $checkout); ?></div>
	<div class="row"><?= wp_get_checkout_field_html('shipping_state', $fields, $checkout); ?></div>
	<div class="row"><?= wp_get_checkout_field_html('shipping_postcode', $fields, $checkout); ?></div>
</div>