<?php
/**
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.3
 */

defined( 'ABSPATH' ) || exit;

if ( ! is_ajax() ) {
	do_action( 'woocommerce_review_order_before_payment' );
}

$payment_title = strval(get_field('checkout_payment_method_title', 'option')); 

$place_order_text = strval(get_field('checkout_place_order', 'option')); 

?>
<ul class="checkout_page_content_steps woocommerce-checkout-payment">
	<li>
		<h2 class="checkout_page_content_steps_title"><span>4</span><?=$payment_title?> <i class="fas fa-lock"></i></h2>
		<div class="inner_grid">
			<div class="rowspan">
				<ul class="checkout_page_content_payment wc_payment_methods payment_methods methods">
				<?php

				if (WC()->cart->needs_payment()):
					if (!empty($available_gateways)){
						foreach($available_gateways as $gateway){
							wc_get_template('checkout/payment-method.php', array('gateway' => $gateway));
						}
					} else { 
					?>
					<li>
						<div class="woocommerce-notice woocommerce-notice--info woocommerce-info">
							<?=apply_filters( 'woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__( 'Sorry, it seems that there are no available payment methods for your state. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce' ) : esc_html__( 'Please fill in your details above to see available payment methods.', 'woocommerce' ) )?>
						</div>
					</li>
					<?php

					}

				endif;

				?>
				</ul>
			</div>
		</div>
	</li>
	<li><?php wc_get_template( 'checkout/terms.php' ); ?></li>
	<li>
		<div class="inner_grid">
			<div class="rowspan">
			<?php wp_nonce_field( 'woocommerce-process_checkout', 'woocommerce-process-checkout-nonce' ); ?>
			<?php do_action( 'woocommerce_review_order_before_submit' ); ?>
				<input type="submit" name="woocommerce_checkout_place_order" data-value="<?=$place_order_text?>" value="<?=$place_order_text?>">
			<?php do_action( 'woocommerce_review_order_after_submit' ); ?>
			</div>
		</div>
	</li>
</ul>
<?php
if ( ! is_ajax() ) {
	do_action( 'woocommerce_review_order_after_payment' );
}
?>