<?php

if(!defined('ABSPATH')){
	exit;
}
?>
<div class="checkout_page_order_table woocommerce-checkout-review-order-table">
	<h2><?=App\Acf::get('checkout_order_details_title', 'option', 'str')?>:</h2>
		<ul class="checkout_page_order_table_product_list">
		<?php 
		foreach(WC()->cart->get_cart() as $cart_item_key=>$cart_item): 
			$wc_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
			if($wc_product && $wc_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key)):
				?>
				<li>
					<header>
						<span class="name"><?=$wc_product->get_name();?></span>
						<span class="qty"><?=$cart_item['quantity']?></span>
						<span class="total"><?=WC()->cart->get_product_price( $wc_product )?></span>
					</header>
					<?php 
					if($cart_item['data']->is_type('variation') && is_array($cart_item['variation'])):
						$attributes_to_print = msb_get_cart_item_attributes($cart_item['variation']);
						if($attributes_to_print):
							?>
							<h4><?=App\Acf::get('checkout_order_details_extra', 'option', 'str')?>:</h4>
							<ul class="extra">
							<?php 
							foreach($attributes_to_print as $attribute):
								?><li><?=$attribute['label']?>: <?=$attribute['value']?></li><?php
							endforeach;
							?></ul><?php 
						endif;
					endif;
					?>
				</li>
				<?php 
			endif;
		endforeach;
		?>
		</ul>
		<ul class="checkout_page_order_table_product_footer">
			<li>
				<span class="title"><?=App\Acf::get('checkout_order_details_subtotal', 'option', 'str')?></span>
				<span class="amount"><?=wc_cart_totals_subtotal_html()?></span>
			</li>
			<?php foreach (WC()->cart->get_coupons() as $code=>$coupon):
				$coupon_object = new WC_Coupon($coupon);
				?><li>
					<span class="title"><?= $coupon_object->get_description() . ' [' .$coupon_object->get_code() . '] ' ?></span>
					<span class="amount"><?php wc_cart_totals_coupon_html($coupon); ?></span>
				</li>
			<?php endforeach; ?>
			<li>
				<span class="title"><?=App\Acf::get('checkout_order_details_total', 'option', 'str')?></span>
				<span class="amount"><?=wc_cart_totals_order_total_html()?></span>
			</li>
	</ul>
</div>