<?php

if(!defined('ABSPATH')){
	exit;
}
$page_title = strval(get_field('checkout_thankyou_title', 'option'));
$success_title = strval(get_field('checkout_thankyou_success_title', 'option'));
$cta_link_to = strval(get_field('checkout_thankyou_cta_to', 'option'));
$cta_link_text = strval(get_field('checkout_thankyou_cta_text', 'option'));
$cta_link_image = msb_get_image_url(get_field('checkout_thankyou_cta_icon', 'option'), 'small');

// order details data vars
$order_details_text_var = get_field('checkout_thankyou_order_details', 'option');
// customer details data vars
$customer_details_text_var = get_field('checkout_thankyou_customer_details', 'option');

do_action('woocommerce_before_thankyou', $order->get_id());
?>
<section class="order_details_page grid">
<?php 
if($order){
	if($order->has_status('failed')):
		?>
		<header class="order_details_page_header">
			<h1 class="order_details_page_title"><?=App\Acf::get('checkout_thankyou_failed_title', 'option', 'str')?></h1>
			<?php if($cta_link_to && $cta_link_text): ?>
				<a href="<?=$cta_link_to?>" class="request"><?php if($cta_link_image): ?><i class="lazyload" data-bg-src="<?=$cta_link_image?>"></i><?php endif; ?><span><?=$cta_link_text?></span></a>
			<?php endif ?>
		</header>
		<?php else: ?>
		<header class="order_details_page_header">
			<h1 class="order_details_page_title"><?=$success_title?></h1>
			<?php if($cta_link_to && $cta_link_image && $cta_link_text): ?>
				<a href="<?=$cta_link_to?>" class="request"><?php if($cta_link_image): ?><i class="lazyload" data-bg-src="<?=$cta_link_image?>"></i><?php endif; ?><span><?=$cta_link_text?></span></a>
			<?php endif ?>
		</header>
		<div class="inner_grid">
			<div class="row">
				<h2 class="order_details_page_subtitle"><?=$order_details_text_var['title']?>:</h2>
				<ul class="order_details_page_list">
					<li>
						<div class="title"><?=$order_details_text_var['number']?>:</div>
						<div class="content"><?=$order->get_order_number()?></div>
					</li>
					<li>
						<div class="title"><?=$order_details_text_var['date']?>:</div>
						<div class="content"><?=wc_format_datetime( $order->get_date_created() )?></div>
					</li>
					<li>
						<div class="title"><?=$order_details_text_var['products']?>:</div>
						<div class="content">
							<ul class="order_details_page_list_product_list">
							<?php
							foreach($order->get_items() as $cart_item_key => $cart_item):
								$wc_product = $cart_item->get_product();
								$product_id = $cart_item['product_id'];
								if($wc_product && $wc_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ):
									$product_permalink = $wc_product->is_visible() ? $wc_product->get_permalink($cart_item) : '';
									?>
									<li>
										<header>
											<a href="<?=$product_permalink?>" target="_blank"><?=$wc_product->get_name()?></a>
											<span class="qty"><?=$cart_item->get_quantity()?></span>
										</header>
										<?php 
										$variation_attributes = msb_get_cart_item_attributes($cart_item->get_meta_data());
										if(!empty($variation_attributes)):
											?>
											<h4><?=$order_details_text_var['products_extra']?>:</h4>
											<ul>
												<?php foreach($variation_attributes as $attribute){ ?>
													<li><?=$attribute['label']?>: <?=$attribute['value']?></li>
												<?php } ?>
											</ul>
											<?php 
										endif;
										?>
										<span class="total"><b><?=$order_details_text_var['subtotal']?>: </b><?=wc_price($cart_item->get_subtotal());?></span>
									</li>
									<?php 
								endif;
							endforeach;
							?>
							</ul>
						</div>
					</li>
					<li>
						<div class="title"><?=$order_details_text_var['subtotal']?>:</div>
						<div class="content"><?=wc_price($order->get_subtotal())?></div>
					</li>
					<?php if($order->get_data()['discount_total'] > 0): ?>
						<li>
							<div class="title"><?=$order_details_text_var['discount']?>:</div>
							<div class="content">-<?=wc_price($order->get_discount_total())?></div>
						</li>
					<?php endif; ?>
					<li>
						<div class="title"><?=$order_details_text_var['shipping']?>:</div>
						<?php 
							$shipping_price = intval($order->get_total_shipping()) ? wc_price($order->get_total_shipping()) : $order_details_text_var['free_shipping'];
						?>
						<div class="content"><?=$shipping_price?></div>
					</li>
					<?php if ( $order->get_payment_method_title() ) : ?>
						<li>
							<div class="title"><?=$order_details_text_var['method']?>:</div>
							<div class="content"><?=$order->get_payment_method_title()?></div>
						</li>
					<?php endif; ?>
					<li>
						<div class="title"><?=$order_details_text_var['total']?>:</div>
						<div class="content"><?=$order->get_formatted_order_total()?></div>
					</li>
				</ul>
			</div>
			<div class="row">
				<h2 class="order_details_page_subtitle"><?=$customer_details_text_var['title']?>:</h2>
				<ul class="order_details_page_list">
					<li>
						<div class="title"><?=$customer_details_text_var['email']?>:</div>
						<div class="content"><?=$order->get_data()['billing']['email']?></div>
					</li>
					<li>
						<div class="title"><?=$customer_details_text_var['phone']?>:</div>
						<div class="content"><?=$order->get_data()['billing']['phone']?></div>
					</li>
					<?php if($order->get_data()['billing']): ?>
						<li>
							<div class="title"><?=$customer_details_text_var['billing']?>:</div>
							<address class="content">
								<ul class="shipping">	
									<?php foreach($order->get_data()['billing'] as $value){ ?>
										<li><?=$value?></li>
									<?php } ?>
								</ul>
							</address>
						</li>
					<?php endif; if($order->get_data()['shipping']): ?>
						<li>
							<div class="title"><?=$customer_details_text_var['shipping']?>:</div>
							<address class="content">
								<ul class="shipping">
								<?php foreach($order->get_data()['shipping'] as $value){ ?>
										<li><?=$value?></li>
									<?php } ?>
								</ul>
							</address>
						</li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
		<?php
	endif;
	do_action( 'woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id() );
	do_action( 'woocommerce_thankyou', $order->get_id() );
	
} else {
	$failed_title = strval(get_field('checkout_thankyou_failed_title', 'option'));
	?>
	<header class="order_details_page_header">
		<h1 class="order_details_page_title"><?=$failed_title?></h1>
		<?php if($cta_link_to && $cta_link_image && $cta_link_text): ?>
		<a href="<?=$cta_link_to?>" class="request"><?php if($cta_link_image): ?><i class="lazyload" data-bg-src="<?=$cta_link_image?>"></i><?php endif; ?><span><?=$cta_link_text?></span></a>
		<?php endif ?>
	</header>
	<?php
	}
	?>
	<div class="returnexchange">
		<?php do_action( 'woocommerce_order_details_after_order_table', $order );?>
	</div>
</section>
