<?php 

if(!defined('ABSPATH')){
	exit;
}

$post_id = App\Storage::get('queried_object_id');
$wc_product = wc_get_product($post_id);

if(empty($wc_product)) msb_set_404();

$msb_product = new App\Product($wc_product);

get_header();
?>
<section class="product_page grid">
    <h1 class="product_page_title"><?=$wc_product->get_name()?></h1>
    <?php if(App\Acf::get('sub_title', $post_id, 'bool')): ?>
     <h2 class="product_page_subtitle"><?=App\Acf::get('sub_title', $post_id, 'str')?></h2>
    <?php endif; ?>
    <section class="product_page_main<?php if(!App\Acf::get('main_tech_gallery_option', $post_id, 'bool')) echo ' no_specs' ?>">
        <div class="product_page_main_info">
            <?php wp_get_product_template_part('gallery'); ?>
            <?php if(App\Acf::get('main_tech_gallery_option', $post_id, 'bool')): ?>
            <div class="product_page_main_specs_benefits">
                <?php
                wp_get_product_template_part('categories'); 
                wp_get_product_template_part('shipping-and-benefits'); 
                ?>
            </div>
            <?php endif ?>
            <div class="product_page_main_footer">
                <?php wp_get_product_template_part('description-and-shop-features'); ?>
            </div>
        </div>
        <div class="product_page_main_payment">
            <?php wp_get_product_template_part('pricing'); ?>
        </div>
</section>
<?php
msb_get_sections();
if($wc_product->get_reviews_allowed()){
    wp_get_product_template_part('comments');
} if(App\Acf::get('related_products_option', $post_id, 'bool')){
    wp_get_product_template_part('related-products');
}
get_footer(); 
?>